/*
   Siag, Scheme In A Grid
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <sys/stat.h>

#include "../common/cmalloc.h"
#include "../common/common.h"

#include "../siag/types.h"
#include "../siag/calc.h"

extern void init_windows1(int *, char **);
extern void mainloop(void);

#ifdef GUILE
#include <guile/gh.h>
#endif

#ifdef TCL
#include <tcl.h>
#endif

#include "../siod/siod.h"

extern void init_position(void);        /* position.c */
extern int init_C_parser(void);         /* ci.c */
extern int init_parser(int, char **);   /* siodi.c */
extern int init_guile_parser(void);     /* guilei.c */
extern void init_interpreters(void);    /* railway.c */

char *siaghome, *siaghelp, *siagdocs, *siag_basedir;
static char *siagrc;

int ok2print = 0;

int siod_interpreter, C_interpreter;

extern char *siag_format;       /* fileio.siag.c */

#ifdef TCL
extern int init_tcl_parser(Tcl_Interp *);       /* tcli.c */

int Tcl_AppInit(Tcl_Interp *interp)
{
        init_tcl_parser(interp);
        mainloop();
        return TCL_OK;  /* it won't, though */
}
#endif

static void malloc_fail_handler(void)
{
        fprintf(stderr, "Out of memory\n");

#if 1
        fprintf(stderr, "\t(should save all changed buffers before aborting)\n");
        abort();
#else
        fprintf(stderr, "Trying to bail out...\n");
        /* delete all windows */
        while (w_list) {
                free_window(w_list);
        }
        /* now say a prayer, close your eyes and jump */
        execute("(quit-siag)");
#endif
        exit(1);
}

void realmain(int argc, char **argv)
{
        char b[256], *home, *p;
        struct stat statbuf;
        buffer *buf = NULL;
        char path[1024];
        int i;

        if ((siaghome = getenv("SIAGHOME")) == NULL) {
                char env[256];
                sprintf(env, "SIAGHOME=%s", SIAGHOME);
                putenv(env);
                siaghome = SIAGHOME;
        }
        if ((siaghelp = getenv("SIAGHELP")) == NULL) {
                char env[256];
                sprintf(env, "SIAGHELP=%s", SIAGHELP);
                putenv(env);
                siaghelp = SIAGHELP;
        }
        if ((siagdocs = getenv("SIAGDOCS")) == NULL) {
                char env[256];
                sprintf(env, "SIAGDOCS=%s", SIAGDOCS);
                putenv(env);
                siagdocs = SIAGDOCS;
        }

	/* i18n */
	if ((p = getenv("SIAGLANG"))) {
		sprintf(b, "%s/common/dictionary.%s", siaghome, p);
		load_dictionary(b);
	}

        if ((home = getenv("HOME")) == NULL)
                home = "";
	sprintf(path, "%s/.siag", home);
	siag_basedir = cstrdup(path);
	mkdir(siag_basedir, 0700);
	sprintf(b, "%s/%ld", siag_basedir, (long)getpid());
	mkdir(b, 0700);
        sprintf(b, "%s/siag.scm", siag_basedir);
        siagrc = cstrdup(b);

        init_windows1(&argc, argv);

        siod_interpreter = init_parser(argc, argv);
        C_interpreter = init_C_parser();
#ifdef GUILE
        init_guile_parser();
#endif
        interp_startup();
        init_mathwrap();        /* standard FP library functions */

        buf = new_buffer("noname.siag", "noname.siag");

        init_windows(buf, argc, argv);

        ok2print = 1;

        init_position();
        init_cmds();

        /* find runtime library */
	sprintf(path, "%s/siag/siag.scm", siaghome);
        if (stat(path, &statbuf)) {
                char *buttons[] = {"OK"};

		fprintf(stderr, "Can't find the runtime library (siag.scm).\n");
		fprintf(stderr, "Expected it in %s\n", path);
		fprintf(stderr, "SIAGHOME is '%s'\n", siaghome);
		fprintf(stderr, "Please read installation instructions.\n");

                alert_box("Can't find siag.scm. Click to exit.", buttons, 1);
                exit(EXIT_FAILURE);
        }

        /* must set SIAGHOME like this if SLIBU is undefined */
	setvar(cintern("SIAGHOME"), strcons(-1, siaghome), NIL);
	setvar(cintern("SIAGHELP"), strcons(-1, siaghelp), NIL);
	setvar(cintern("SIAGDOCS"), strcons(-1, siagdocs), NIL);

        /* now load runtime library */
        sprintf(b, "(load \"%s/siag/siag.scm\")", siaghome);
        execute(b);

        /* load user customizations, if any */
        if (!stat(siagrc, &statbuf)) {
                sprintf(b, "(load \"%s\")", siagrc);
                execute(b);
        }

        fileio_init();
        for (i = 1; i < argc; i++) {
                if (argv[i][0] != '-') {

                        strncpy(path, argv[i], 1020);
                        buf = new_buffer(buffer_name(argv[i]), path);
                        /* make it less clueless */
                        loadmatrix(path, buf, guess_file_format(path));

                        calc_matrix(buf);
                        buf->change = FALSE;
                        w_list->buf = buf;
                }
        }
        pr_scr_flag = TRUE;

        /* this works, for reasons beyond my comprehension */
        execute("(print-version)");
        execute("(print-version)");
        activate_window(w_list);

        waitforchild(0);

        /* we now have "valuable" data, so need for a better handler */
        cmalloc_init(malloc_fail_handler, 2);

#ifdef TCL
        Tcl_Main(argc, argv, Tcl_AppInit);
#else
        mainloop();
#endif
}

int main(int argc, char **argv)
{
#ifdef GUILE
        gh_enter(argc, argv, realmain);
#else
        realmain(argc, argv);
#endif
        return 0;
}

