
#ifndef __GTK_SGRID_H__
#define __GTK_SGRID_H__

enum {SGRID_TEXT = 1, SGRID_PIXMAP, SGRID_EMBED};

#include <gtk/gtk.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_SGRID(obj)\
		GTK_CHECK_CAST(obj, gtk_sgrid_get_type(), GtkSGrid)
#define GTK_SGRID_CLASS(klass)\
		GTK_CHECK_CLASS_CAST(klass, gtk_sgrid_get_type(), GtkGridClass)
#define GTK_IS_SGRID(obj)\
		GTK_CHECK_TYPE(obj, gtk_sgrid_get_type())

typedef struct s_GtkSGrid GtkSGrid;
typedef struct s_GtkSGridClass GtkSGridClass;

struct s_GtkSGridClass
{
  GtkWidgetClass parent_class;
  void (* clicked)(GtkSGrid *sgrid);
};

struct s_GtkSGrid {
  GtkWidget widget;                                       /* parent class */
  gint max_row, max_col;                /* last row/col that can be shown */
  gint prot_row, prot_col;               /* num of rows/cols always shown */
  GtkAdjustment *hadjustment;                   /* adjustment for top_col */
  GtkAdjustment *vadjustment;                   /* adjustment for top_row */
  gint top_row, top_col;               /* first unprotected row/col drawn */
  gint sel_top_row, sel_bottom_row;     /* selection */      /* not used yet in ml */
  gint sel_left_col, sel_right_col;     /* selection */      /* not used yet in ml */
  gint point_row, point_col;                        /* location of cursor */
  gint default_width, default_height;      /* default cell size in pixels */
  
  /* query functions that describe cells */
  gint (*col_width)(GtkSGrid *ng, gpointer data, gint col);     
  gint (*row_height)(GtkSGrid *ng, gpointer data, gint row);
  gint (*format)(GtkSGrid *, gpointer, gint, gint);
  gint (*type)(GtkSGrid *ng, gpointer data, gint row, gint col);
  char *(*text)(GtkSGrid *ng, gpointer data, gint row, gint col);

  gpointer data;             /* arbitrary user data passed to query funcs */
  guint grid_lines : 1;                               /* draw grid lines? */
  guint visible_cursor : 1;                           /* draw cursor?     */

  /* private state */
  GdkGC *non_gr_exp_gc;                               /* gc for ? */
  GdkGC *xor_gc;                                      /* gc for cursor */
  GdkColor *bg;
};

guint      gtk_sgrid_get_type   (void);
GtkWidget* gtk_sgrid_new        (gint rows, gint cols) ;
void       gtk_sgrid_size       (GtkSGrid      *grid,
				 gint          width,
				 gint          height) ;

void gtk_sgrid_rowcol_to_coord(GtkSGrid *grid,
			       gint cell_row, gint cell_col,
			       gint *cell_x,  gint *cell_y) ;
void gtk_sgrid_coord_to_rowcol(GtkSGrid *tw,
			       int cur_x, int cur_y,
			       int *cur_row, int *cur_col) ;

void gtk_sgrid_set_point (GtkSGrid *sgrid, gint row, gint col) ;
void gtk_sgrid_get_point (GtkSGrid *sgrid, gint *row, gint *col) ;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTH_SGRID_H__ */

