/*
   Egon Animator
   Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * fileio_ps.c
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>

#include "../xcommon/Animator.h"
#include "egon.h"
#include "types.h"
#include "../common/common.h"
#include "../common/fonts.h"
#include "../xcommon/embed.h"

/* format guessing:
   1. extension .ps
   2. Starts with "%!PS"
*/
#define PS_MAGIC "%!PS"
static int myformat(char *fn)
{
	char *ext;
	FILE *fp = NULL;
	char b[250];
	int result;

	result = ((ext = strrchr(fn, '.')) &&
		!cstrcasecmp(ext, ",ps") &&
		(fp = fopen(fn, "r")) &&
		fgets(b, sizeof b, fp) &&
		!strncmp(b, PS_MAGIC, strlen(PS_MAGIC)));
	if (fp) fclose(fp);
	return result;
}

void fileio_ps_init()
{
	register_format(NULL, NULL, myformat, "Postscript (*.ps)");
}

