/*
 * Copyright 1995,96,97 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: samuel.h,v 2.5 1997/04/18 15:56:24 bousch Exp $
 *
 * Data structures and prototypes for the "Samuel" calculator
 */

typedef struct _samid {
	struct _samid *next;
	mref_t mref;
	char name[0];
} sam_id;

extern sam_id *id_table;
extern int mr_model;
extern int quiet;
extern const char *post_processor;

int yylex(void), yyparse(void);
void init_lexer (void);
void print_cpu_usage (void);
void list_variables (void);
void assign_to_variable (const char* var, mref_t mr);
int read_variable (mref_t mr, const char* var);
int destroy_variable (const char* var);
int execute_function (const char* cmd, int nb_args);
void read_identifier (mref_t mr, const char *name);
void write_mref_to_file (const char* file, mref_t mr);
void read_mref_from_file (mref_t mr, const char* var);
void panic (const char *message);

mref_t make_square_matrix (int n2);
mref_t pop_mref (void);
void push_mref (mref_t);
void clean_stack (void);

int fn_determinant (mref_t result, int argc, mref_t *argv);
int fn_getpid (mref_t result, int argc, mref_t *argv);
int fn_sqrt (mref_t result, int argc, mref_t *argv);
int fn_variables (mref_t result, int argc, mref_t *argv);
