#!/bin/sh
# Shell wrapper for R executable.
# Just sets a few environment items

RHOME=R_HOME_DIR
export RHOME

if [ "$1" = "RHOME" ]
then
	echo $RHOME; exit 0
fi
    
if [ "$1" = "SHLIB" ]
then
	shift
	exec sh $RHOME/etc/SHLIB $*
fi

if [ "$1" = "COMPILE" ]
then
	shift
	exec sh $RHOME/etc/COMPILE $*
fi

if [ "$1" = "INSTALL" ]
then
        shift
        exec sh $RHOME/etc/INSTALL $*
fi

if [ "$1" = "REMOVE" ]
then
        shift
        exec sh $RHOME/etc/REMOVE $*
fi

if [ "$1" = -xxgdb ]
then
	shift
	DEBUGGER=xxgdb
fi

if [ "$1" = -gdb ]
then
	shift
	DEBUGGER=gdb
fi

# Default Printer Paper Size
# Choose one of the following
# R_PAPERSIZE="a4"
# R_PAPERSIZE="letter"
# R_PAPERSIZE="none"
R_PAPERSIZE=a4
export R_PAPERSIZE

# Default Print Command
# Choose one of the following
# R_PRINTCMD="lpr"
# R_PRINTCMD="lp"
R_PRINTCMD=lpr
export R_PRINTCMD

if [ $DEBUGGER ]
then
	exec $DEBUGGER $RHOME/bin/R.binary 
else
	exec $RHOME/bin/R.binary  $*
fi
