/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: init_windows.c,v 1.4 1998/03/20 07:27:31 lance Exp $ */
#include <stdio.h>
#include <assert.h>
#include <string.h>

#include "xwin.h"
#include "data.h"

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Viewport.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Form.h>
#include <X11/cursorfont.h>


#define WIN_TITLE_SIZE 200
#define ICON_TITLE_SIZE 40
#define DUMMY_STRING "                                                                                   "
extern int get_window_size(Display *display, Window window, 
				 unsigned int *width, 
				 unsigned int *height);
extern unsigned long GetNamedColor(Display *dpy, Colormap cmap, char *name);
extern void draw_plot(PlotXwins *win,Plot *plot);

static struct
{
  PlotXwins *win;
  Plot *plot;
} CallBackData;


static Pixel get_pix_color(PlotXwins *win, char *color)
{
  Pixel pix;

  pix = GetNamedColor(win->display,
		      DefaultColormap(win->display,win->screen_number),
		      color);
  return pix;
}

static int Get_XColor(PlotXwins *win, char *color, XColor *xcolor)
{
  if(XParseColor(win->display,DefaultColormap(win->display,win->screen_number),
		 color, xcolor) == 0 ||
     XAllocColor(win->display,DefaultColormap(win->display,win->screen_number),
		 xcolor) == 0)
    {
      /* fprintf(stderr,"quickplot Info: Can't get xcolor \"%s\" in %s line %d.\n",
	    __FILE__,__LINE__);*/
      return 0;
    }
  return 1;
  
}

static void Get_BackgroundColor(PlotXwins *win, Widget widget, char *color_return)
{
  Pixel pix;
  XtVaGetValues(widget, XtNbackground, &pix, NULL);
  if(pix == BlackPixel(win->display, win->screen_number))
      sprintf(color_return,"white");
  else
      sprintf(color_return,"black");
}


static void quit_callback(Widget w, XtPointer appdata, XtPointer calldata)
{
  exit(0);
}

static void redraw_callback(Widget w, XtPointer appdata, XtPointer calldata)
{
  draw_plot(CallBackData.win,CallBackData.plot);
}

static void handle_wm_message(Widget w, XtPointer client, Boolean *dispatch)
{
  if(XtIsRealized(((PlotXwins *)client)->popWig))
    XtUnrealizeWidget(((PlotXwins *)client)->popWig);
}

int check_popWig(PlotXwins *win, Plot *plot)
{
  int i;
  Atom xa_wm_protocol, protocol[1];

  if(XtIsRealized(win->popWig))
    return 0;
  else
    {
      XtRealizeWidget(win->popWig);
      for(i=0;i<plot->num_plots;i++)
        XtVaSetValues(win->valueWig[i],XtNforeground, plot->line_color[i],NULL);
      xa_wm_protocol = XInternAtom(XtDisplay(win->popWig), "WM_PROTOCOLS",False);
      protocol[0] = XInternAtom(XtDisplay(win->popWig), "WM_DELETE_WINDOW",False);
      XSetWMProtocols(XtDisplay(win->popWig), XtWindow(win->popWig),
		      protocol, XtNumber(protocol));
      XtAddEventHandler(win->popWig, NoEventMask, True,
			(XtEventHandler) handle_wm_message,
			(XtPointer) win );
      return 1;
    }
}

static void mode_callback(Widget w, XtPointer appdata, XtPointer calldata)
{
  if((CallBackData.win)->mode & VALUE_MODE)
    {
      XtVaSetValues(w,XtNlabel, "Edit Mode ",NULL);
      (CallBackData.win)->mode = EDIT_MODE;
    }
  else
    {
      XtVaSetValues(w,XtNlabel, "Value Mode",NULL);
      (CallBackData.win)->mode = VALUE_MODE;
    }
}

void init_windows(int argc, char **argv, PlotXwins *win, Plot *plot)
{
  int x,y,i;
  unsigned int  width, height;
  XFontStruct *font_struct;
  char win_title[WIN_TITLE_SIZE + 1], icon_title[ICON_TITLE_SIZE];
  Cursor gumby_cursor;
  XColor xgreen, xbg;
  Widget boxWig,viewportWig;
  char str5[6];
  char *fallback_resources[6];
  char str0[] = {"quickplot*reverseVideo: true"};
  char str1[] = {"quickplot*plot.width:          500"};
  char str2[] = {"quickplot*plot.height:          500"};
  char str3[] = {"quickplotvalues.width:          600"};
  char str4[] = {"quickplotvalues.height:          100"};

  fallback_resources[0] = str0;
  fallback_resources[1] = str1;
  fallback_resources[2] = str2;
  fallback_resources[3] = str3;
  fallback_resources[4] = str4;
  fallback_resources[5] = NULL;

  CallBackData.plot = plot;
  CallBackData.win = win;

  if(plot->infiles[0] == NULL)
    {
      sprintf(win_title,"LANCEMAN'S QuickPlot");
      sprintf(icon_title,"QuickPlot");
    }
  else
    {
      win_title[0] = '\0';
      icon_title[0] = '\0';
      strncat(win_title,"QuickPlot file =",WIN_TITLE_SIZE - strlen(win_title));
      for(i=0;plot->infiles[i] != NULL;i++)
	{	 
	  strncat(win_title," ",WIN_TITLE_SIZE - strlen(win_title));
	  strncat(win_title,plot->infiles[i],WIN_TITLE_SIZE - 
		  strlen(win_title));
	  if(i>0) strncat(icon_title," ",ICON_TITLE_SIZE - strlen(icon_title));
	  strncat(icon_title,plot->infiles[i],ICON_TITLE_SIZE - 
		  strlen(icon_title));
	}
    }
  /* Open in then close the display just to get the
   * width and height of the root window.
   * Is there a better way?
   */
  if((win->display = XOpenDisplay((char *)NULL)) == (Display*) NULL)
    {
      fprintf(stderr,"quickplot ERROR: Can't open display\n");
      exit(1);
    }
  get_window_size(win->display, DefaultRootWindow(win->display), 
		  &width, &height);
  XCloseDisplay(win->display);

  XtToolkitInitialize();
  win->context = XtCreateApplicationContext();

  /* setup plot and value window size */
  width = (width > 1000)?600:2*width/3;
  height = (height > 900)?500:height/2;

  sprintf(&(fallback_resources[1][22]),"%d",width);
  sprintf(&(fallback_resources[2][23]),"%d",height);
  sprintf(&(fallback_resources[3][23]),"%d",width);
  sprintf(&(fallback_resources[4][24]),"%d",height/3);

  /*for(i=0;i<5;i++)
printf("fallback_resources[%d] = <%s>\n",i,fallback_resources[i]);*/

  XtAppSetFallbackResources(win->context,fallback_resources);

  if((win->display = XtOpenDisplay(win->context,"", "quickplot",
				       "Quickplot",
                          NULL, 0, &argc, argv)) == (Display*) NULL)
    {
      fprintf(stderr,"quickplot ERROR: Can't open display\n");
      exit(1);
    }
 
  win->screen_number = DefaultScreen(win->display);

  win->toplevelWig = XtVaAppCreateShell("quickplot", "QuickPlot",
					applicationShellWidgetClass,
					win->display,
					XtNborderWidth,0,
					XtNtitle, win_title,
					XtNiconName, icon_title,
					NULL);
  SetIconImage(win->toplevelWig, True);

  win->managerWig = XtVaCreateManagedWidget("manager", formWidgetClass,
					    win->toplevelWig,
					    XtNdefaultDistance, 0,
					    XtNborderWidth,0 ,
					    NULL);

  win->menuWig = XtVaCreateManagedWidget( "menu" , formWidgetClass,
					  win->managerWig,
					  XtNborderWidth,0 ,
					  XtNleft, XtChainLeft,
					  XtNright, XtChainLeft,
					  XtNbottom, XtChainTop,
					  XtNtop, XtChainTop,
					  NULL);

  gumby_cursor = XCreateFontCursor(win->display,XC_gumby);

  win->quitWig = XtVaCreateManagedWidget( "quit", commandWidgetClass,
					  win->menuWig,
					  XtNlabel, "Quit",
					  XtNleft, XtChainLeft,
					  XtNright, XtChainLeft,
					  XtNcursor, gumby_cursor,
 /* why is gumby_green not working */ /*  XtNpointerColor, gumby_green(win),*/
					  NULL);

  win->modeWig = XtVaCreateManagedWidget( "mode", commandWidgetClass,
					  win->menuWig,
					  XtNfromHoriz, win->quitWig,
					  XtNlabel, "Value Mode",
					  XtNleft, XtChainLeft,
					  XtNright, XtChainLeft,
					  NULL);

  win->redrawWig = XtVaCreateManagedWidget( "redraw", commandWidgetClass,
					  win->menuWig,
					  XtNfromHoriz, win->modeWig,
					  XtNlabel, "Redraw",
					  XtNleft, XtChainLeft,
					  XtNright, XtChainLeft,
					    /* XtNsensitive,False,*/
					  NULL);

  win->plotWig = XtVaCreateManagedWidget("plot",simpleWidgetClass,
					 win->managerWig,
					 XtNfromVert, win->menuWig,
					 XtNright, XtChainRight,
					 XtNtop, XtChainTop,
					 XtNleft, XtChainLeft,
					 XtNbottom, XtChainBottom,
					 XtNborderWidth,2,
					 NULL);

  XtRealizeWidget(win->toplevelWig);

  
#if(1)
  /* make quit cursor gumby green */
  if(Get_XColor(win,"green", &xgreen))
    {
      Get_BackgroundColor(win,win->quitWig,str5);
      if(Get_XColor(win,str5, &xbg))
	XRecolorCursor(win->display, gumby_cursor, &xbg ,&xgreen);
    }
#else /* this dosen't work on my machine */
  XtVaSetValues(win->modeWig,XtNpointerColorBackground, get_pix_color(win,"green"));
#endif

  win->mode = VALUE_MODE; /* default mouse mode */
  /* if there is a phase plot or one of the 
   * function plots does not have the same x-values 
   * then disable the editing mode.
   */
  for(i=0;i<plot->num_plots;i++)
    if((plot->plot_opt[i] & PHASE_PLOT) ||
       (plot->list[i][X] != plot->list[0][X]))
      break;
  if(i == plot->num_plots) /* no phase plots */
    {
      XtAddCallback(win->modeWig, XtNcallback, mode_callback,NULL);
    }
  else
    XtVaSetValues(win->modeWig,XtNsensitive,False,NULL);

  XtAddCallback( win->quitWig, XtNcallback, quit_callback, NULL);
  XtAddCallback( win->redrawWig, XtNcallback, redraw_callback, NULL);
  /*  XtVaSetValues(win->redrawWig,XtNsensitive,False,NULL);*/

  XSelectInput(win->display,win->plotwin = XtWindow(win->plotWig),
	       ExposureMask | ButtonPressMask | StructureNotifyMask |
               PointerMotionMask | PointerMotionHintMask | ButtonReleaseMask);

  /* get a font */
  if(NULL == (font_struct=XLoadQueryFont(win->display,"fixed")))
    {
      fprintf(stderr,"quickplot ERROR: opening font failed.\n");
      XtCloseDisplay(win->display);
      exit(1);
    }
  win->gc = DefaultGC(win->display,win->screen_number);
  XSetFont(win->display,win->gc,font_struct->fid);

  strncat(win_title," -- Values Window",WIN_TITLE_SIZE - strlen(win_title));
  win->popWig = XtVaAppCreateShell("quickplotvalues" , "QuickPlotValues",
				   applicationShellWidgetClass,win->display,
				   XtNtitle, win_title,
				   XtNiconName, "Values",
				   NULL);

  SetIconImage(win->popWig, True);

  viewportWig = XtVaCreateManagedWidget("valueveiwport", viewportWidgetClass,
					win->popWig,
					XtNallowHoriz, True,
					XtNallowVert, True,
					NULL);
  boxWig = XtVaCreateManagedWidget("valuebox", formWidgetClass, viewportWig, NULL);

  assert(NULL != (win->valueWig = (Widget *) malloc(plot->num_plots*sizeof(Widget))));
 win->valueWig[0] = XtVaCreateManagedWidget("value",asciiTextWidgetClass,
					       boxWig,
					    XtNstring,DUMMY_STRING,
					XtNborderWidth,0,
					  XtNleft, XtChainLeft,
					  XtNright, XtChainLeft,
					  XtNbottom, XtChainTop,
					  XtNtop, XtChainTop,
					  XtNresizable, True,
					  XtNresize, XawtextResizeWidth,
					  XtNdisplayCaret, False,
					  NULL);

  for(i=1;i<plot->num_plots;i++)
    win->valueWig[i] = XtVaCreateManagedWidget("value",asciiTextWidgetClass,
					       boxWig,
					       XtNstring,DUMMY_STRING,
					XtNborderWidth,0,
					  XtNleft, XtChainLeft,
					  XtNright, XtChainLeft,
					  XtNbottom, XtChainTop,
					  XtNtop, XtChainTop,
					  XtNresizable, True,
					       XtNfromVert, win->valueWig[i-1],   
					       XtNresize, XawtextResizeWidth,
					       XtNdisplayCaret, False,
					       NULL);

  win->popflag = 0;
}


#if(0)
#endif
