/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: draw_zoom_box.c,v 1.2 1998/03/10 04:15:55 lance Exp $ */
#include <stdio.h>
#include <assert.h>

#include "data.h"
#include "xwin.h"

GC band_gc;


extern int get_window_size(Display *display, Window window, 
				 unsigned int *width, 
				 unsigned int *height);
/* setup gc for rubber bands */
void setup_rubber_bands(PlotXwins *win,Plot *plot)
{
  XGCValues gcvalues;
  unsigned long l;

  gcvalues.background = 0UL;
  gcvalues.foreground = WhitePixel(win->display,win->screen_number);
  gcvalues.function = GXxor;

  band_gc = XCreateGC(win->display,win->plotwin,
		      GCFunction | GCForeground | GCBackground,
		      &gcvalues);
}

/* Blocks until it get an event */
/* returns 0 if Button 2 is pressed or released else returns 1 */
static int look_for_ButtonRelease(PlotXwins *win)
{
  XEvent event;

  XWindowEvent(win->display,win->plotwin,
	       PointerMotionMask | ButtonReleaseMask | ButtonPressMask,&event);
  switch(event.type)
    {
    case ButtonPress:
    case ButtonRelease:
      if(event.xbutton.button == Button2)
	return 0;
      return 1;
    default:
      return 1;
    }
}

/* returns 1 on failure */
int get_pointer_postion(PlotXwins *win, int *xi, int *yi)
{
  Window root_return, child_return;
  int root_x_return, root_y_return;
  unsigned int mask_return;

  if(XQueryPointer(win->display,win->plotwin,&root_return,&child_return,
                   &root_x_return, &root_y_return, xi,yi,&mask_return))
    return 0;
  return 1;
}


void draw_rubber_bands(PlotXwins *win, int *xout, int *yout, 
		       unsigned int *widthout, unsigned int *heightout)
{
  int xi,yi,x0,y0,x,y;
  unsigned int width0, width, height0, height;


  if(get_pointer_postion(win,&xi,&yi))
    {
      fprintf(stderr,"quickplot ERROR: can't get pointer position in file %s line %d\n",
	      __FILE__,__LINE__);
      return;
    }
  XDrawRectangle(win->display,win->plotwin,band_gc, xi, yi,
		 width=width0=0, height=height0=0);
  XFlush(win->display);
  x0 = x = xi; y0 = y = yi;
  while(look_for_ButtonRelease(win))
    {
      if(get_pointer_postion(win,&x,&y))
	{
	  fprintf(stderr,"quickplot ERROR: can't get pointer position: file %s line %d\n",
		  __FILE__,__LINE__ -3);
	  return;
	}
      if(x != x0 || y != y0)
	{
	  if(x > xi)
	    {
	      width = x - xi;
	      x = xi;
	    }
	  else
	    width = xi - x;
	  if(y > yi)
	    {
	      height = y - yi;
	      y = yi;
	    }
	  else
	    height = yi - y;
	  XDrawRectangle(win->display,win->plotwin,band_gc, x0, y0,width0, height0);
	  XDrawRectangle(win->display,win->plotwin,band_gc, x, y,width, height);
	  x0 = x; y0 = y;  width0 = width; height0 = height;
	  XFlush(win->display);
	}
    }
  XDrawRectangle(win->display,win->plotwin,band_gc, x0, y0,width0, height0);
  XFlush(win->display);
  *xout = x0; *yout = y0; *widthout = width0; *heightout = height0;
}

int zoom_plot(PlotXwins *win, Plot *plot, int boxx, int boxy,
		      unsigned int boxwidth, unsigned int boxheight)
{
  unsigned int width,height;
  int i,j,k;

  get_window_size(win->display,win->plotwin,&width,&height);

  if((boxx < 0 || boxx+boxwidth > width) && (boxy < 0 || boxy+boxheight > height))
    {
      plot->zoom_count = 0;
      return 1;
    }
  else if(boxx < 0 || boxy < 0 || boxx+boxwidth > width || boxy+boxheight > height)
    {
      plot->zoom_count -= (plot->zoom_count > 0)? 1:0;
      return 1;
    }
  else if(boxwidth == 0 || boxheight == 0)
    return 0;
  else
    {
      plot->zoom_count++;
      if(plot->zoom_count >= plot->num_zoom)
	{ 
	  /*** get more zoom variables */
	  plot->zoom_count = plot->num_zoom;
	  plot->num_zoom += DEFAULT_NUM_ZOOM;
	  assert((plot->z_scale=(double **)realloc(plot->z_scale,
			      sizeof(double *)*plot->num_zoom))!=NULL);
	  assert((plot->z_shift=(double **)realloc(plot->z_shift,
			      sizeof(double *)*plot->num_zoom))!=NULL);

	  assert((plot->start=(Data ****)realloc(plot->start,
                sizeof(Data ***)*plot->num_zoom))!=NULL);
	  assert((plot->end  =(Data ****)realloc(plot->end,
                sizeof(Data ***)*plot->num_zoom))!=NULL);
	  for(i=plot->zoom_count;i<plot->num_zoom;i++)
	    {
	      assert((plot->z_scale[i]=(double *)malloc(sizeof(double)*2))!=NULL);
	      assert((plot->z_shift[i]=(double *)malloc(sizeof(double)*2))!=NULL);

	      assert((plot->start[i]=(Data ***)malloc(
                     sizeof(Data **)*plot->num_plots))!=NULL);
	      assert((plot->end[i]  =(Data ***)malloc(
                     sizeof(Data **)*plot->num_plots))!=NULL);
	      for(j=0;j<plot->num_plots;j++)
		{
		  assert((plot->start[i][j]=(Data **)malloc(
			        sizeof(Data *)*2))!=NULL);
		  assert((plot->end[i][j]  =(Data **)malloc(
				sizeof(Data *)*2))!=NULL);
		}
	    }
	}
      plot->z_scale[plot->zoom_count][X] = 
	plot->z_scale[plot->zoom_count-1][X]*width/(boxwidth*(2.0-FRACTION_WINDOW_USE));
      plot->z_scale[plot->zoom_count][Y] = 
        plot->z_scale[plot->zoom_count-1][Y]*height/(boxheight*(2.0-FRACTION_WINDOW_USE));

      plot->z_shift[plot->zoom_count][X] = 
	(plot->z_scale[plot->zoom_count][X]/plot->z_scale[plot->zoom_count-1][X])*
	(plot->z_shift[plot->zoom_count-1][X]
	- boxx + (1.0 - FRACTION_WINDOW_USE)*boxwidth/2.0);

      plot->z_shift[plot->zoom_count][Y] =
	(plot->z_scale[plot->zoom_count][Y]/plot->z_scale[plot->zoom_count-1][Y])*
	(plot->z_shift[plot->zoom_count-1][Y]
	- boxy + (1.0 - FRACTION_WINDOW_USE)*boxheight/2.0);
      for(j=0;j<plot->num_plots;j++)
	{
	  plot->start[plot->zoom_count][j][X] = plot->start[plot->zoom_count - 1][j][X];
	  plot->start[plot->zoom_count][j][Y] = plot->start[plot->zoom_count - 1][j][Y];
	  plot->end[plot->zoom_count][j][X] = plot->end[plot->zoom_count - 1][j][X];
	  plot->end[plot->zoom_count][j][Y] = plot->end[plot->zoom_count - 1][j][Y];
	}
      return 1;
    }
}
