.TH "hmmpfam" 1 "March 1998" "HMMER 2.0" "HMMER Manual"

.SH NAME
.TP 
hmmpfam - search a single sequence against an HMM database

.SH SYNOPSIS
.B hmmpfam
.I [options]
.I hmmfile
.I seqfile

.SH DESCRIPTION

.B hmmpfam
reads a single sequence from
.I seqfile
and compares it against all the HMMs in
.I hmmfile
looking for significantly similar sequence matches.

.PP
.I hmmfile
will be looked for first in the current working directory,
then in a directory named by the environment variable
.I HMMERDB.
This lets administrators install HMM library(s) such as
Pfam in a common location.

.PP
The output consists of three sections: a ranked list
of the best scoring HMMs, a list of the
best scoring domains in order of their occurrence
in the sequence, and alignments for all the best scoring
domains.
A sequence score may be higher than a domain score for
the same sequence if there is more than one domain in the sequence;
the sequence score takes into account all the domains.
All sequences scoring above the 
.I -E
and
.I -T 
cutoffs are shown in the first list, then 
.I every 
domain found in this list is
shown in the second list of domain hits.
If desired, E-value and bit score thresholds may also be applied
to the domain list using the
.I --domE
and
.I --domT
options.

.SH OPTIONS

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -n
Specify that models and sequence are nucleic acid, not protein.
Other HMMER programs autodetect this; but because of the order in
which 
.B hmmpfam
accesses data, it can't reliably determine the correct "alphabet"
by itself.

.TP
.BI -A " <n>"
Limits the alignment output to the 
.I <n>
best scoring domains.
.B -A0
shuts off the alignment output and can be used to reduce
the size of output files.

.TP
.BI -E " <x>"
Set the E-value cutoff for the per-sequence ranked hit list to 
.I <x>,
where
.I <x>
is a positive real number. The default is 10.0. Hits with E-values
better than (less than) this threshold will be shown.

.TP 
.BI -T " <x>"
Set the bit score cutoff for the per-sequence ranked hit list to
.I <x>,
where
.I <x> 
is a real number.
The default is negative infinity; by default, the threshold
is controlled by E-value and not by bit score.
Hits with bit scores better than (greater than) this threshold
will be shown.

.TP
.BI -Z " <n>"
Calculate the E-value scores as if we had seen a sequence database of 
.I <n>
sequences. The default is arbitrarily set to 59021, the size of
Swissprot 34.

.SH EXPERT OPTIONS

.TP
.BI --domE " <x>"
Set the E-value cutoff for the per-domain ranked hit list to
.I <x>,
where 
.I <x>
is a positive real number.
The default is infinity; by default, all domains in the sequences
that passed the first threshold will be reported in the second list,
so that the number of domains reported in the per-sequence list is
consistent with the number that appear in the per-domain list.

.TP 
.BI --domT " <x>"
Set the bit score cutoff for the per-domain ranked hit list to
.I <x>,
where 
.I <x>
is a real number. The default is negative infinity; 
by default, all domains in the sequences
that passed the first threshold will be reported in the second list,
so that the number of domains reported in the per-sequence list is
consistent with the number that appear in the per-domain list.
.I Important note:
only one domain in a sequence is absolutely controlled by this
parameter, or by
.B --domT. 
The second and subsequent domains in a sequence have a de facto
bit score threshold of 0 because of the details of how HMMER
works. HMMER requires at least one pass through the main model
per sequence; to do more than one pass (more than one domain)
the multidomain alignment must have a better score than the
single domain alignment, and hence the extra domains must contribute
positive score. See the Users' Guide for more detail.

.TP
.BI --forward
Use the Forward algorithm instead of the Viterbi algorithm
to determine the per-sequence scores. Per-domain scores are
still determined by the Viterbi algorithm. Some have argued that
Forward is a more sensitive algorithm for detecting remote
sequence homologues; my experiments with HMMER have not
confirmed this, however.

.TP 
.B --null2
Turn off the post hoc second null model. By default, each alignment
is rescored by a postprocessing step that takes into account possible
biased composition in either the HMM or the target sequence.
This is almost essential in database searches, especially with
local alignment models. There is a very small chance that this
postprocessing might remove real matches, and 
in these cases
.B --null2 
may improve sensitivity at the expense of reducing
specificity by letting biased composition hits through.

.TP
.B --xnu
Turn on XNU filtering of target protein sequences. Has no effect
on nucleic acid sequences. In trial experiments, 
.B --xnu
appears to perform less well than the default
post hoc null2 model.

.SH SEE ALSO

.PP
hmmalign(1), hmmbuild(1), hmmcalibrate(1),
hmmconvert(1), hmmemit(1), hmmer(1), hmmsearch(1)
.PP
User guide and tutorial: Userguide.ps
.PP
WWW: 
.B http://hmmer.wustl.edu/

.SH AUTHOR

This software and documentation is Copyright (C) 1992-1998 Washington
University School of Medicine.  It is freely distributable under terms
of the GNU General Public License. See COPYING in the source code
distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


