/*
 * Grace - Graphics for Exploratory Data Analysis
 * 
 * Home page: http://plasma-gate.weizmann.ac.il/Grace/
 * 
 * Copyright (c) 1991-95 Paul J Turner, Portland, OR
 * Copyright (c) 1996-98 GRACE Development Team
 * 
 * Maintained by Evgeny Stambulchik <fnevgeny@plasma-gate.weizmann.ac.il>
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *
 * Global variables for gr
 *
 */

#ifndef __GLOBALS_H_
#define __GLOBALS_H_

#include <stdlib.h>
#include <stdio.h>

#include "defines.h"
#include "draw.h"


#ifdef MAIN

char docname[GR_MAXPATHLEN] = NONAME;
char description[2048];
char workingdir[GR_MAXPATHLEN];

int debuglevel = 0;
int sigcatch = TRUE;		/* we handle signals ourselves */

int maxplot = MAXPLOT;
int maxarr = MAXARR;
int maxgraph = MAXGRAPH;

int maxboxes = MAXBOXES;
int maxlines = MAXLINES;
int maxstr = MAXSTR;
int maxellipses = MAXELLIPSES;

DrawProps draw_props;		/* Current drawing properties */

int ptofile = FALSE;            /* flag to indicate destination of hardcopy
                                 * output, ptofile = 0 means print to printer
                                 * non-zero print to file */

char sformat[128] = "%16lg %16lg"; /* format for saving (ascii) projects */

double *ax, *bx, *cx, *dx;	/* scratch arrays used in scanner */


int logwindow = FALSE;		/* TRUE if results are displayed in the log window */


char currentdir[GR_MAXPATHLEN];	/* current directory */
char grace_home[GR_MAXPATHLEN];	/* location of Grace home directory */
char help_viewer[256];		/* HTML helper command*/

/*
 * named pipes
 */
int timer_delay = 1000;         /* timer */
int named_pipe;			/* true if named pipe is active */
char pipe_name[GR_MAXPATHLEN];	/* path to named pipe */

/*
 * scroll amount
 */
int scrolling_islinked = FALSE;	/* linked scroll */
double scrollper = 0.05;	/* scroll fraction */
double shexper = 0.05;		/* expand/shrink fraction */

int linked_zoom = FALSE;	/* when zooming, apply to all graphs */

char plfile[GR_MAXPATHLEN];	/* load parameters file name */
char fname[GR_MAXPATHLEN];		/* last data file read */

int device;			/* graphics device */
int tdevice;                    /* default device */
int hdevice;                    /* hardcopy device */

int monomode = FALSE;		/* set mono mode */
int invert = FALSE;		/* use GXxor or GXinvert for xor'ing */
int autoscale_onread = FALSE;	/* autoscale after reading data from fileswin.c */
int auto_redraw = TRUE;		/* if true, redraw graph each time action is
				 * performed */
int verify_action = FALSE;	/* request verification of actions if TRUE */
int allow_dc = TRUE;		/* allow double click ops */
int status_auto_redraw = TRUE;	/* if true, redraw graph each time action is
				 * performed in the status window */
int force_redraw = FALSE;	/* if no auto draw and re-draw pressed */
int noask = FALSE;              /* if TRUE, assume yes for everything (dangerous) */

int index_shift = 0; 		/* 0 for C, 1 for F77 index notation */

char progname[MAX_STRING_LENGTH];	/* our name */

char resfile[GR_MAXPATHLEN];	/* results to file resfile */
FILE *resfp;			/* file for results */

int inwin = FALSE;		/* true if running X */

char buf[1024];			/* a string used here and there */

int epsflag = FALSE;		/* force eps to be written */
int ps2flag = TRUE;		/* allow use of Level 2 PS (for patterns) */


defaults grdefaults;		/* default properties */

/* graph definition */
graph *g;
int cg = 0;			/* the current graph */

/* region definition */
region rg[MAXREGION];
int nr = 0;			/* the current region */

plotstr *pstr;       /* strings */
boxtype *boxes;    /* boxes */
linetype *lines;   /* lines */
ellipsetype *ellip;   /* ellipses */

plotstr defpstr;
linetype defline;
boxtype defbox;
ellipsetype defellip={TRUE,COORD_VIEW,0,0,0,0,0,1,1,1,1,0};

/* lines and ellipses and boxes flags */
int box_color = 1;
int box_lines = 1;
int box_linew = 1;
int box_fillpat = 0;
int box_fillcolor = 1;
int box_loctype = COORD_VIEW;

int ellipse_color = 1;
int ellipse_lines = 1;
int ellipse_linew = 1;
int ellipse_fillpat = 0;
int ellipse_fillcolor = 1;
int ellipse_loctype = COORD_VIEW;

int line_color = 1;
int line_arrow = 0;
int line_lines = 1;
int line_linew = 1;
int line_loctype = COORD_VIEW;
double line_asize = 1.0;
int line_atype = 0;

/* default string parameters */
int string_color = 1;
int string_linew = 1;
int string_font = 0;
int string_rot = 0;
int string_just = 0;
int string_fillpat = 1;
int string_fillcolor = 1;
int string_loctype = COORD_VIEW;
double string_size = 1.0;

int curset, curaxis;
int focus_policy = FOCUS_CLICK;

int revflag = FALSE;

int draw_focus_flag = TRUE;

int page_layout = PAGE_FIXED;

plotstr timestamp;       /* timestamp */

/*
 * for the status popup
 */
int cur_statusitem = STATUS_SETS;

/*
 * used in the parser
 */
int cursource = SOURCE_DISK, curtype = SET_XY;

int format_types[] = {FORMAT_DECIMAL, FORMAT_EXPONENTIAL, FORMAT_GENERAL, FORMAT_POWER,
                      FORMAT_SCIENTIFIC, FORMAT_ENGINEERING,
		      FORMAT_DDMMYY, FORMAT_MMDDYY, FORMAT_YYMMDD, FORMAT_MMYY, FORMAT_MMDD,
        	      FORMAT_MONTHDAY, FORMAT_DAYMONTH, FORMAT_MONTHS, FORMAT_MONTHSY, FORMAT_MONTHL, FORMAT_DAYOFWEEKS,
        	      FORMAT_DAYOFWEEKL, FORMAT_DAYOFYEAR, FORMAT_HMS, FORMAT_MMDDHMS, FORMAT_MMDDYYHMS, FORMAT_YYMMDDHMS,
        	      FORMAT_DEGREESLON, FORMAT_DEGREESMMLON, FORMAT_DEGREESMMSSLON, FORMAT_MMSSLON,
        	      FORMAT_DEGREESLAT, FORMAT_DEGREESMMLAT, FORMAT_DEGREESMMSSLAT, FORMAT_MMSSLAT, FORMAT_INVALID};


/* block data globals */
double **blockdata;
int maxblock = MAXPLOT;
int blocklen;
int blockncols;

#if defined(HAVE_NETCDF) || defined(HAVE_MFHDF)
int readcdf = FALSE;
char netcdf_name[512], xvar_name[128], yvar_name[128];
#endif

/* parameters for non-linear fit */
nonlparms nonl_parms[MAXPARM];
nonlopts nonl_opts;
nonlprefs nonl_prefs;

int symcolorbug = 0;

target target_set; /* target */

int dl_load_fast = TRUE; /* controls type of DL module load */
/* TODO: make it tunable through a command */

#endif

#ifndef MAIN

extern char *open_err_msg;

extern char docname[];
extern char description[];
extern char workingdir[];

extern int debuglevel;
extern int sigcatch;		/* true if we handle signals ourselves */

extern int inwin;		/* true if running X */
extern int ispipe;		/* true if reading from stdin */

extern int maxarr, maxplot, maxgraph;

extern int maxboxes;
extern int maxlines;
extern int maxstr;
extern int maxellipses;

extern DrawProps draw_props;		/* Current drawing properties */

extern int ptofile;		/* flag to indicate destination of hardcopy
                                 * output, ptofile = 0 means print to printer
                                 * non-zero print to file */

extern char sformat[];

extern int logwindow;		/* TRUE if results are displayed in the log window */

extern char plfile[], psfile[];
extern char resfile[];
extern FILE *resfp;

extern int device, tdevice, hdevice;

extern int monomode;		/* set mono mode */
extern int invert;		/* use GXxor or GXinvert for xor'ing */
extern int autoscale_onread;	/* autoscale after reading data from fileswin.c */
extern int noask;		/* if TRUE, assume yes for everything (dangerous) */

extern int index_shift; 	/* 0 for C, 1 for F77 index notation */

extern char currentdir[];	/* current directory */
extern char grace_home[];	/* location of Grace home directory */
extern char help_viewer[];	/* help viewer command*/

extern int canvasw;		/* canvas dimensions */
extern int canvash;

extern int timer_delay;		/* timer */
extern int named_pipe;		/* true if named pipe is active */
extern char pipe_name[];	/* path to named pipe */

extern int scrolling_islinked;	/* linked scroll */
extern double scrollper;	/* scroll fraction */
extern double shexper;		/* expand/shrink fraction */
extern int linked_zoom;		/* when zooming, apply to all graphs */

extern char fname[];
extern int nsets;
extern char buf[];

extern int epsflag;		/* force eps to be written */
extern int ps2flag ;		/* allow use of Level 2 PS (for patterns) */

extern int verify_action;	/* request verification of actions if TRUE */
extern int allow_dc;		/* allow double click ops */

extern double *ax, *bx, *cx, *dx;

extern defaults grdefaults;	/* default properties */

/* graph definition */
extern graph *g;
extern int cg;

/* region definition */
extern region rg[];
extern int nr;

extern plotstr *pstr;		/* strings */
extern boxtype *boxes;		/* boxes */
extern linetype *lines;		/* lines */
extern ellipsetype *ellip;	/* ellipses */

extern plotstr defpstr;
extern linetype defline;
extern boxtype defbox;
extern ellipsetype defellip;

extern int box_color;
extern int box_lines;
extern int box_linew;
extern int box_fill;
extern int box_fillpat;
extern int box_fillcolor;
extern int box_loctype;

extern int ellipse_color;
extern int ellipse_lines;
extern int ellipse_linew;
extern int ellipse_fill;
extern int ellipse_fillpat;
extern int ellipse_fillcolor;
extern int ellipse_loctype;

extern int line_color;
extern int line_arrow;
extern int line_lines;
extern int line_linew;
extern int line_loctype;
extern double line_asize;
extern int line_atype;

extern int string_color;
extern int string_linew;
extern int string_font;
extern int string_rot;
extern int string_just;
extern int string_fill;
extern int string_fillpat;
extern int string_fillcolor;
extern int string_loctype;
extern double string_size;

extern int auto_redraw;
extern int status_auto_redraw;
extern int force_redraw;

extern double charsize, xlibcharsize;	/* declared in draw.c and xlib.c resp. */

extern int curset, curaxis;
extern int focus_policy;
extern int draw_focus_flag;
extern int revflag;

extern plotstr timestamp;       /* timestamp */
extern int page_layout;

extern int cur_statusitem;

extern int cursource, curtype;
extern int format_types[];

extern double **blockdata;
extern int maxblock;
extern int blocklen;
extern int blockncols;

#if defined(HAVE_NETCDF) || defined(HAVE_MFHDF)
extern int readcdf;
extern char netcdf_name[];
extern char xvar_name[];
extern char yvar_name[];
#endif

/* parameters for non-linear fit */
extern nonlparms nonl_parms[];
extern nonlopts nonl_opts;
extern nonlprefs nonl_prefs;

extern int symcolorbug;

extern target target_set; /* target */

extern int dl_load_fast; /* controls type of DL module load */

#endif

#endif /* __GLOBALS_H_ */
