/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"

Mesh *
MeshDice(m, proc)
    Mesh           *m;
    int             (*proc) ();
{
	int             u, v;
	int             nu, nv;
	float           umin, umax, vmin, vmax;
	float           fu, fv;
	Point3          *n;
	HPoint3		*p;

	if (m && proc)
	{
		umin = m->umin;
		umax = m->umax;
		vmin = m->vmin;
		vmax = m->vmax;
		nu = m->nu;
		nv = m->nv;
		p = m->p;
		n = m->n;
		for (v = 0; v < nv; v++)
		{
			for (u = 0; u < nu; u++)
			{
				fu = umin + ((umax - umin) * u) / (nu - 1);
				fv = vmin + ((vmax - vmin) * v) / (nv - 1);
				(*proc) (fu, fv, p, n);
				if (n)
					n++;
				p++;
			}
		}
	}
	return m;
}
