/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

Transform3 TM3_IDENTITY = {

    1.0, 0.0, 0.0, 0.0,
    0.0, 1.0, 0.0, 0.0,
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0 

};

/*
 * Initialize a matrix to identity
 *
 *       ( 1 0 0 0 )
 *       ( 0 1 0 0 )
 * [a] = ( 0 0 1 0 )
 *       ( 0 0 0 1 )
 */
void
Tm3Identity( T )
    Transform3 T;
{
    Tm3Copy( TM3_IDENTITY, T );
}

