/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef HPLANE3DEF
#define HPLANE3DEF

#ifndef HPOINT3DEF
# include "hpoint3.h"
#endif

extern HPlane3 *HPl3Create();
extern void HPl3Delete( HPlane3 *pl );

extern void HPl3Print( HPlane3 *pl );
extern void HPl3Copy( HPlane3 *pl1, HPlane3 *pl2 );
extern void HPl3From( HPlane3 *pl, HPl3Coord a, HPl3Coord b, HPl3Coord c, HPl3Coord d );
extern int HPl3From3HPt3s( HPlane3 *pl, HPoint3 *pt1, HPoint3 *pt2, HPoint3 *pt3 );
extern int HPl3From2HLn3s( HPlane3 *pl, HLine3 *ln1, HLine3 *ln2 );

extern int HPl3IntersectHPl3( HPlane3 *pl1, HPlane3 *pl2, HLine3 *ln );
extern void HPl3Pencil( HPl3Coord t1, HPlane3 *pl1, HPl3Coord t2, HPlane3 *pl2, HPlane3 *pl );

extern float HPl3DotHPt3( HPlane3 *pl, HPoint3 *pt );

extern HPl3Normalize( HPlane3 *pl1, HPlane3 *pl2 );

extern int HPl3Undefined( HPlane3 *pl );
extern int HPl3Infinity( HPlane3 *pl );
extern int HPl3Compare( HPlane3 *pl1, HPlane3 *pl2 );

extern int HPl3CoincidentHPt3( HPlane3 *pl, HPoint3 *pt );
extern int HPl3CoincidentHLn3( HPlane3 *pl, HLine3 *ln );
extern int HPl3CoincidentHPl3( HPlane3 *pl1, HPlane3 *pl2 );

extern void HPl3Transform( Transform3 T, HPlane3 *pl1, HPlane3 *pl2 );
extern void HPl3TransformN( Transform3 T, HPlane3 *pl1, HPlane3 *pl2, int n );

extern void HPl3Dual( HPlane3 *pl, HPoint3 *pt );

/* Identify ideal plane */
extern HPlane3 HPl3Ideal;
extern void HPl3Perp( HPlane3 *pl, HPoint3 *pt );
extern HPl3Coord HPl3Angle( HPlane3 *pl1, HPlane3 *pl2 );

#endif
