#include "polylistP.h"

main(argc, argv)
	char *argv[];
{
	PolyList *pl;
	register int i, n;
	register Vertex **vp, *v;
	register Poly *p;
	ColorA *c;
	char *kind;

	if(argc <= 1) {
	    fprintf(stderr, "Usage: offcvt [-a]   infile.off  >outfile.off\n\
Converts an .off file to binary form, writes it to stdout.\n\
With -a, converts to ASCII form instead.  Input file may be \"-\" for stdin.\n");
	    exit(1);
	}

	i = 0;
	if(argv[1][0] == '-' && argv[1][1] == 'a') {
	    i++;
	    argc--, argv++;
	}

	pl = (PolyList *)((argc <= 1 || argv[1][0] == '-')
		? GeomFLoad(stdin, "-") : GeomLoad(argv[1]));
	if(pl == NULL) {
		perror(argv[1]);
		exit(1);
	}
	kind = GeomName((Geom *)pl);
	if(kind == NULL || strcmp(kind, "polylist") != 0) {
	    fprintf(stderr, "offcvt: input is a %s, not an OFF object\n", kind);
	    exit(1);
	}

	if(i) {
		PolyListFSave(pl, stdout, "stdout");
		exit(0);
	}

	printf("%s%s%sOFF BINARY\n",
                &"C"[pl->flags & PL_HASVCOL ? 0 : 1],
                &"N"[pl->flags & PL_HASVN ? 0 : 1],
                &"4"[pl->geomflags & VERT_4D ? 0 : 1]);
	putw(pl->n_verts, stdout);
	putw(pl->n_polys, stdout);
	putw(pl->n_verts + pl->n_polys - 2, stdout);

	for(i = pl->n_verts, v = pl->vl; --i >= 0; v++) {
	    Point3 pt;
	    HPt3ToPt3( &v->pt, &pt );
	    fwrite(&pt, 1, sizeof(Point3), stdout);
	}

	for(i = pl->n_polys, p = pl->p; --i >= 0; p++) {
	    n = p->n_vertices;
	    putw(n, stdout);
	    for(vp = p->v; --n >= 0; vp++)
		putw((*vp) - pl->vl, stdout);
	    if(pl->flags & PL_HASPCOL) {
		putw(4, stdout);
		fwrite(&p->pcol, 1, sizeof(ColorA), stdout);
	    } else {
		putw(0, stdout);
	    }
	}
	exit(0);
}
