/* We include the C code generated by the forms designer (fdesign2). */
#include <stdlib.h>
#include "discgrpP.h"
#include "dgflag.h"
#include "maniview.h"

#include "forms.h"
#include "xforms-compat.h"
#include "controlpanel.c"

  static int display_winid = -1,
	enum_winid = -1,
	load_winid = -1,
	save_winid = -1,
	dirdom_winid = -1,
	info_winid = -1,
	help_winid = -1;



#define TOGGLE(xxx, bit, button) 	\
	xxx = fl_get_button(button) ? (xxx | bit) : (xxx & ~bit)

static int oldspace = DG_EUCLIDEAN;

int loadstuff();
void savegroup();

/* This is the callback procedure we must write. It's the interface
   between our program and the forms code.
 */

void DspyattrProc(FL_OBJECT *obj, long val)
{
  TOGGLE(dg->flag,  val, obj);
  changed = CHANGED;
}

void SoftshadeProc(FL_OBJECT *obj, long val)
{
  softshade = 1 - softshade;
  changed = SOFTSHADE;
}

void RadiusProc(FL_OBJECT *obj, long val)
{
  dg->enumdist = fl_get_slider_value(obj);
  changed = CHANGED;
}

void DrawRadiusProc(FL_OBJECT *obj, long val)
{
  dg->drawdist = fl_get_slider_value(obj);
  changed = CHANGED;
}


void DisplayProc(FL_OBJECT *obj, long val)
{
  TOGGLE(dg->flag, val, obj); 
  changed = CHANGED;
}


void TileModeProc(FL_OBJECT *obj, long val)
{
  tilemode = val;
  fl_set_button(DirichletDomainButton, tilemode & DIRDOM_MODE );
  fl_set_button(UsergeometryButton, tilemode & USER_GEOM );
}

void DDXYProc(FL_OBJECT *obj, long val)
{
  dg->cpoint.x = fl_get_positioner_xvalue(obj);
  dg->cpoint.y = fl_get_positioner_yvalue(obj);
  changed = DIRDOM | CHANGED;
}

void DDZProc(FL_OBJECT *obj, long val)
{
  dg->cpoint.z = fl_get_dial_value(obj);
  changed = DIRDOM | CHANGED;
}

void DDResetProc(FL_OBJECT *obj, long val)
{
  dg->cpoint.x = 0.0;
  dg->cpoint.y = 0.0;
  dg->cpoint.z = 0.0;
  dg->cpoint.w = 1.0;
  fl_update_from_dg(dg);
  changed = DIRDOM | CHANGED;
}

void WorddepthProc(FL_OBJECT *obj, long val)
{
  dg->enumdepth = fl_get_counter_value(obj);
  changed = CHANGED;
}

void DDScaleProc(FL_OBJECT *obj, long val)
{
  myscale = fl_get_slider_value(obj);
  if (tilemode == DIRDOM_MODE) dg->scale = myscale;
  changed = DIRDOM | CHANGED;
}

void Attenuation1SliderProc(FL_OBJECT *obj, long val)
{
  atk[myindex][0] = fl_get_slider_value(obj);
  changed = NEW_AP;
}

void Attenuation2SliderProc(FL_OBJECT *obj, long val)
{
  atk[myindex][1] = fl_get_slider_value(obj);
  changed = NEW_AP;
}

void Attenuation3SliderProc(FL_OBJECT *obj, long val)
{
  atk[myindex][6] = fl_get_slider_value(obj);
  changed = NEW_AP;
}

void DisplayButtonProc(FL_OBJECT *obj, long val)
{
  if (display_winid < 0)	/* not currently active */
  	display_winid = fl_show_form(DisplayForm,displayplacement,TRUE,"Maniview Display Window");
  else {
 	winset(display_winid);
	winpop();
	}
}

void EnumerateButtonProc(FL_OBJECT *obj, long val)
{
  if (enum_winid < 0)	/* not currently active */
  	enum_winid = fl_show_form(EnumForm,enumplacement,TRUE,"Maniview Enum Window");
  else {
 	winset(enum_winid);
	winpop();
	}
}

void TileButtonProc(FL_OBJECT *obj, long val)
{
  if (dirdom_winid < 0)	/* not currently active */
  	dirdom_winid = fl_show_form(TileForm,dirdomplacement,TRUE,"Maniview Tile Window");
  else {
 	winset(dirdom_winid);
	winpop();
	}
}

void HelpButtonProc(FL_OBJECT *obj, long val)
{
  if (help_winid < 0)	/* not currently active */
  	help_winid = fl_show_form(HelpForm,helpplacement,TRUE,"Maniview Help Window");
  else {
 	winset(help_winid);
	winpop();
	}
}

void LoadButtonProc(FL_OBJECT *obj, long val)
{
  if (load_winid < 0)	/* not currently active */
  	load_winid = fl_show_form(LoadForm,loadplacement,TRUE,"Maniview Load Window");
  else {
 	winset(load_winid);
	winpop();
	}
}

void SaveButtonProc(FL_OBJECT *obj, long val)
{
  if (save_winid < 0)	/* not currently active */
  	save_winid = fl_show_form(SaveForm,loadplacement,TRUE,"Maniview Save Window");
  else {
 	winset(save_winid);
	winpop();
	}
}

void InfoButtonProc(FL_OBJECT *obj, long val)
{
  if (info_winid < 0)	/* not currently active */
  	info_winid = fl_show_form(InfoForm,infoplacement,TRUE,"Maniview Info Window");
  else {
 	winset(info_winid);
	winpop();
	}
}

void QuitButtonProc(FL_OBJECT *obj, long val)
{
  exit(0); 
}

void HelpOKButtonProc(FL_OBJECT *obj, long val)
{
  fl_hide_form(HelpForm);
  help_winid = -1;
}

static int loadtypechanged = 1;	/* Flag: when to change filebrowser dir? */

void LoadProc(FL_OBJECT *obj, long val)
{
  loadtypechanged = 1;
  if(fl_get_button(obj))
    loadtype = val;
}

void LoadOKButtonProc(FL_OBJECT *obj, long val)
{
  char filename[128];
  FILE *fp;

  sprintf(filename,"%s",fl_get_input(LoadInput));
  /* get new group */
  if((fp = get_input_fp(filename, loadtype)) != NULL &&
					loadstuff(fp, filename, loadtype)) {
    fl_hide_form(LoadForm);
    load_winid = -1;
  } else {
    strcat(filename, "?");
    fl_set_input(LoadInput, filename);
  }
}

void LoadShowBrowserProc(FL_OBJECT *obj, long val)
{
  char dirname[512];
  char *stem = getenv("GEOMDATA");
  char *subdir = "geom";
  char *pat = "*.dgp";
  char *msg;
  const char *fname;

  if(stem == NULL) stem = ".";
 
  switch(loadtype) {
    case LOAD_GROUP:   msg = "Select Group File"; subdir = "groups";   break;
    case LOAD_CAMGEOM: msg = "Select Camera Geometry File"; pat = "*"; break;
    case LOAD_GEOM:    msg = "Select Geometry File";        pat = "*"; break;
  }
  sprintf(dirname, "%s/%s", stem, subdir);
  fname = fl_show_file_selector(msg,
			loadtypechanged ? dirname : NULL,
			pat, NULL);
  loadtypechanged = 0;
  if(fname) {
    fl_set_input(LoadInput, fname);
    LoadOKButtonProc(LoadOKButton, 0);
  }
}

void SaveOKButtonProc(FL_OBJECT *obj, long val)
{
  char filename[128];
  FILE *fp;

  fl_hide_form(SaveForm);
  save_winid = -1;
  sprintf(filename,"%s",fl_get_input(SaveInput));
  /* get new group */
  savegroup(filename);
}

void SaveGeomButtonProc(FL_OBJECT *obj, long val)
{
  TOGGLE(dg->flag, DG_SAVEDIRDOM, obj); 
}

void SaveGroupButtonProc(FL_OBJECT *obj, long val)
{
  TOGGLE(dg->flag, DG_SAVEBIGLIST, obj); 
}

void DisplayOKButtonProc(FL_OBJECT *obj, long val)
{
  fl_hide_form(DisplayForm);
  display_winid = -1;
}

void EnumOKButtonProc(FL_OBJECT *obj, long val)
{
  fl_hide_form(EnumForm);
  enum_winid = -1;
}

void TileOKButtonProc(FL_OBJECT *obj, long val)
{
  fl_hide_form(TileForm);
  dirdom_winid = -1;
}

void InfoOKButtonProc(FL_OBJECT *obj, long val)
{
  fl_hide_form(InfoForm);
  info_winid = -1;
}

void LoadCancelButtonProc(FL_OBJECT *obj, long val)
{
  fl_hide_form(LoadForm);
  load_winid = -1;
}

void SaveCancelButtonProc(FL_OBJECT *obj, long val)
{
  fl_hide_form(SaveForm);
  save_winid = -1;
}

/* little routine to basically compute log base 2 of the space bit for use
as index into above atk array */
int
index_from_bit(int bit)
{
    if (bit == 1) return(0);
    if (bit == 2) return (1);
    if (bit == 4) return (2);
    else return (1);
}

FILE *
get_input_fp(char *filename, int lt)
{
    char *geomdata, mystr[128];
    FILE *myf;

    if (filename == NULL) return NULL;
    /* try opening the file as given */
    strncpy(mystr, filename, 128);
    if ( (myf = fopen(mystr, "rb")) == NULL)	{
	/* now tack on the geomdata environment variable */
    	geomdata = getenv("GEOMDATA");
	if (geomdata == NULL) 	{
	    fprintf(stderr,"GEOMDATA environment variable not set\n");
	    return(NULL);
	    }
	else {
    	    strncpy(mystr, geomdata, 128);
	    if (lt & LOAD_GROUP) strcat(mystr, "/groups/");
	    else  strcat(mystr,"/geom/");
	    strcat(mystr, filename);
	    myf = fopen(mystr, "rb");
	    }
	}
    if (myf == NULL) {
	fprintf(stderr,"Maniview: Unable to open file %s\n", mystr);
	}
    return (myf);
}

int
loadstuff(FILE  *myf, char *filename, int lt)
{
    int ok = 0;
    DiscGrp *olddg = dg;
    oldspace = space;

  if (lt & (LOAD_GROUP | CHECK_PIPE) )	{	
    if ( (dg = (DiscGrp *) GeomFLoad(myf, filename)) == NULL)	{
      	fprintf(stderr,"Unable to load file %s\n",filename);
	goto OUT;
    	}
    if (olddg) GeomDelete((Geom *) olddg); 
    space = dg->attributes & DG_METRIC_BITS;
    myindex = index_from_bit(space);

    if (oldspace != space ) changed = NEW_SPACE;
    changed |= (CHANGED | NEW_AP );

    if (changed & NEW_SPACE) fl_set_bounds();
    }

  else if (lt & LOAD_GEOM) { 
    Geom *geom, *inst;
    Transform t1;
    if ( (dg->geom && dg->geom != dg->ddgeom)) GeomDelete(dg->geom);
    if ( (geom = GeomFLoad(myf, filename)) == NULL)	{
      	fprintf(stderr,"Unable to load file %s\n",filename);
	goto OUT;
    	}
    /* create an inst with geom */
    TmIdentity(t1);
    dg->geom = GeomCreate("inst", CR_GEOM, geom, CR_AXIS, t1, CR_END);
    changed |= DIRDOM | CHANGED;
    }

  else if (lt & LOAD_CAMGEOM)	{ 
    if ( (dg->camgeom )) GeomDelete(dg->camgeom);
    if ( (dg->camgeom = GeomFLoad(myf, filename)) == NULL)	{
      	fprintf(stderr,"Unable to load file %s\n",filename);
	goto OUT;
    	}
    changed |= CHANGED;
    }
  ok = 1;
OUT:
  if (myf && myf != stdin) fclose(myf);
  return ok;
}

void
savegroup(char *filename)
{
    if (dg) GeomSave( (Geom *) dg,filename);
}



