/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * mouse.c: mouse computations
 */

#include "window.h"
#include "common.h"
#include "mouse.h"

Event oldmouse;
static float olddist = 0;

void
mousezero(Event *event,  WnPosition *wp)
{
  oldmouse = *event;
}


void
mousedisp(Event *event, float *dx, float *dy, unsigned long int *dt, WnPosition *wp)
{
  *dx = 2. * (event->x - oldmouse.x) / (wp->xmax - wp->xmin + 1);
  *dy = 2. * (event->y - oldmouse.y) / (wp->ymax - wp->ymin + 1);
  *dt = event->t - oldmouse.t;
  mousezero(event, wp);
}

void
radialmousezero(Event *event, WnPosition *wp)
{
  float x,y;
  float xw = wp->xmax - wp->xmin + 1;
  float yw = wp->ymax - wp->ymin + 1;

  x = (event->x - wp->xmin) / xw - 0.5;
  y = (event->y - wp->ymin) / yw - 0.5;
  olddist = sqrt( x*x + y*y );
}

float
radialmousedisp(Event *event, WnPosition *wp)
{
  float x, y, dist, val;
  float xw = wp->xmax - wp->xmin + 1;
  float yw = wp->ymax - wp->ymin + 1;

  x = (event->x - wp->xmin) / xw - 0.5;
  y = (event->y - wp->ymin) / yw - 0.5;

  dist = sqrt( x*x + y*y );
  val = dist - olddist;
  olddist = dist;
  return 2 * val;
}

void
mousemap(int x, int y, float *rx, float *ry, WnPosition *wp)
{
  *rx = 2. * (x - wp->xmin) / (wp->xmax - wp->xmin + 1) - 1;
  *ry = 2. * (y - wp->ymin) / (wp->ymax - wp->ymin + 1) - 1;
}
