#ifndef POINTLIST_H
#define POINTLIST_H

/* 
 * Call this to register pointlist routines.
 */
void pointlist_init();


HPoint3 *PointList_get(Geom *geom, Transform T, int CoordSystem);
HPoint3 *PointList_fillin(Geom *geom, Transform T, 
                          int CoordSystem, HPoint3 *plist);
void PointList_set(Geom *geom, int CoordSystem, HPoint3 *plist);
int PointList_length(Geom *geom);


/* 
 * Flags for describing coordinates.  
 * POINTLIST_SELF	This geomview object
 * POINTLIST_PRIMITIVE	Lowest-level OOGL primitive
 */
#define POINTLIST_SELF 0
#define POINTLIST_PRIMITIVE 1

#endif
