/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*	Winged edge data structure represented in Lincoln file format


		\               /	 
		 \             /
		  \           /
		   \         /
		 e00\       /e10
		     \     /
		      \   /
			v0
			|
			|
			|
        f0		|e                 f1
			|
			|
			|
			|
			v1
                       / \
                      /   \
                  e01/     \e11
                    /       \
                   /         \
                  /           \

*/

#define BUFSIZE 256

struct position  {
	float x,y,z,w;
		};

struct equation	{
	float x,y,z,w;
		};

/*
struct vertexchars	{  information will be stored here
	to give the characteristics of an vertex (e.g. pointtype, color,...) }
*/

struct vertex	{	
	struct position pos;
	struct edge *e;
	int order;
/*	struct vertexchars chars;		*/
		};

/*
struct edgechars	{  information will be stored here
	to give the characteristics of an edge (e.g. thickness, color,...) }
*/

struct edge	{
	struct vertex *v0,*v1;
	struct face   *f0,*f1;
	struct edge   *e00,*e01,*e10,*e11;
/*	struct edgechars chars;			*/
		};

struct facechars	{  
	int color;	};

struct face	{	
	struct equation eqn;
	struct edge *e;
	int order;
	struct facechars chars;			
		};

struct data    { char title[BUFSIZE]; int dim, nvertices, nedges, nfaces, nobjects ;} ;
