/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:54 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 10 */

/*
 * This function contains 211 FP additions, 119 FP multiplications,
 * (or, 151 additions, 59 multiplications, 60 fused multiply/add),
 * 40 stack variables, and 80 memory accesses
 */
static const fftw_real K250000000 = FFTW_KONST(+0.250000000000000000000000000000000000000000000);
static const fftw_real K951056516 = FFTW_KONST(+0.951056516295153572116439333379382143405698634);
static const fftw_real K587785252 = FFTW_KONST(+0.587785252292473129168705954639072768597652438);
static const fftw_real K559016994 = FFTW_KONST(+0.559016994374947424102293417182819058860154590);
static const fftw_real K500000000 = FFTW_KONST(+0.500000000000000000000000000000000000000000000);
static const fftw_real K1_902113032 = FFTW_KONST(+1.902113032590307144232878666758764286811397268);
static const fftw_real K1_175570504 = FFTW_KONST(+1.175570504584946258337411909278145537195304875);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);
static const fftw_real K1_118033988 = FFTW_KONST(+1.118033988749894848204586834365638117720309180);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_10(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (10 * iostride);
     {
	  fftw_real tmp198;
	  fftw_real tmp206;
	  fftw_real tmp218;
	  fftw_real tmp226;
	  fftw_real tmp215;
	  fftw_real tmp225;
	  fftw_real tmp205;
	  fftw_real tmp223;
	  fftw_real tmp209;
	  fftw_real tmp211;
	  fftw_real tmp213;
	  fftw_real tmp214;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp196;
	       fftw_real tmp197;
	       fftw_real tmp216;
	       fftw_real tmp217;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp196 = X[0];
	       tmp197 = X[5 * iostride];
	       tmp198 = tmp196 - tmp197;
	       tmp206 = tmp196 + tmp197;
	       tmp216 = Y[-4 * iostride];
	       tmp217 = Y[-iostride];
	       tmp218 = tmp216 - tmp217;
	       tmp226 = tmp216 + tmp217;
	  }
	  tmp213 = Y[-2 * iostride];
	  tmp214 = Y[-3 * iostride];
	  tmp215 = tmp213 - tmp214;
	  tmp225 = tmp213 + tmp214;
	  {
	       fftw_real tmp201;
	       fftw_real tmp207;
	       fftw_real tmp204;
	       fftw_real tmp208;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp199;
		    fftw_real tmp200;
		    fftw_real tmp202;
		    fftw_real tmp203;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp199 = X[2 * iostride];
		    tmp200 = X[3 * iostride];
		    tmp201 = tmp199 - tmp200;
		    tmp207 = tmp199 + tmp200;
		    tmp202 = X[4 * iostride];
		    tmp203 = X[iostride];
		    tmp204 = tmp202 - tmp203;
		    tmp208 = tmp202 + tmp203;
	       }
	       tmp205 = tmp201 + tmp204;
	       tmp223 = K1_118033988 * (tmp201 - tmp204);
	       tmp209 = tmp207 + tmp208;
	       tmp211 = K1_118033988 * (tmp207 - tmp208);
	  }
	  X[5 * iostride] = tmp198 + (K2_000000000 * tmp205);
	  {
	       fftw_real tmp227;
	       fftw_real tmp229;
	       fftw_real tmp224;
	       fftw_real tmp228;
	       fftw_real tmp222;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp227 = (K1_175570504 * tmp225) - (K1_902113032 * tmp226);
	       tmp229 = (K1_902113032 * tmp225) + (K1_175570504 * tmp226);
	       tmp222 = tmp198 - (K500000000 * tmp205);
	       tmp224 = tmp222 - tmp223;
	       tmp228 = tmp223 + tmp222;
	       X[7 * iostride] = tmp224 - tmp227;
	       X[3 * iostride] = tmp224 + tmp227;
	       X[iostride] = tmp228 - tmp229;
	       X[9 * iostride] = tmp228 + tmp229;
	  }
	  X[0] = tmp206 + (K2_000000000 * tmp209);
	  {
	       fftw_real tmp219;
	       fftw_real tmp221;
	       fftw_real tmp212;
	       fftw_real tmp220;
	       fftw_real tmp210;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp219 = (K1_175570504 * tmp215) - (K1_902113032 * tmp218);
	       tmp221 = (K1_902113032 * tmp215) + (K1_175570504 * tmp218);
	       tmp210 = tmp206 - (K500000000 * tmp209);
	       tmp212 = tmp210 - tmp211;
	       tmp220 = tmp211 + tmp210;
	       X[2 * iostride] = tmp212 - tmp219;
	       X[8 * iostride] = tmp212 + tmp219;
	       X[6 * iostride] = tmp220 - tmp221;
	       X[4 * iostride] = tmp220 + tmp221;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 9) {
	  fftw_real tmp78;
	  fftw_real tmp145;
	  fftw_real tmp120;
	  fftw_real tmp155;
	  fftw_real tmp115;
	  fftw_real tmp116;
	  fftw_real tmp93;
	  fftw_real tmp96;
	  fftw_real tmp166;
	  fftw_real tmp165;
	  fftw_real tmp152;
	  fftw_real tmp174;
	  fftw_real tmp104;
	  fftw_real tmp111;
	  fftw_real tmp123;
	  fftw_real tmp125;
	  fftw_real tmp177;
	  fftw_real tmp176;
	  fftw_real tmp162;
	  fftw_real tmp169;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp76;
	       fftw_real tmp77;
	       fftw_real tmp118;
	       fftw_real tmp119;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp76 = X[0];
	       tmp77 = Y[-5 * iostride];
	       tmp78 = tmp76 + tmp77;
	       tmp145 = tmp76 - tmp77;
	       tmp118 = Y[0];
	       tmp119 = X[5 * iostride];
	       tmp120 = tmp118 - tmp119;
	       tmp155 = tmp118 + tmp119;
	  }
	  {
	       fftw_real tmp81;
	       fftw_real tmp146;
	       fftw_real tmp91;
	       fftw_real tmp150;
	       fftw_real tmp84;
	       fftw_real tmp147;
	       fftw_real tmp88;
	       fftw_real tmp149;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp79;
		    fftw_real tmp80;
		    fftw_real tmp89;
		    fftw_real tmp90;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp79 = X[2 * iostride];
		    tmp80 = Y[-7 * iostride];
		    tmp81 = tmp79 + tmp80;
		    tmp146 = tmp79 - tmp80;
		    tmp89 = Y[-6 * iostride];
		    tmp90 = X[iostride];
		    tmp91 = tmp89 + tmp90;
		    tmp150 = tmp89 - tmp90;
	       }
	       {
		    fftw_real tmp82;
		    fftw_real tmp83;
		    fftw_real tmp86;
		    fftw_real tmp87;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp82 = Y[-8 * iostride];
		    tmp83 = X[3 * iostride];
		    tmp84 = tmp82 + tmp83;
		    tmp147 = tmp82 - tmp83;
		    tmp86 = X[4 * iostride];
		    tmp87 = Y[-9 * iostride];
		    tmp88 = tmp86 + tmp87;
		    tmp149 = tmp86 - tmp87;
	       }
	       {
		    fftw_real tmp85;
		    fftw_real tmp92;
		    fftw_real tmp148;
		    fftw_real tmp151;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp115 = tmp81 - tmp84;
		    tmp116 = tmp88 - tmp91;
		    tmp85 = tmp81 + tmp84;
		    tmp92 = tmp88 + tmp91;
		    tmp93 = tmp85 + tmp92;
		    tmp96 = K559016994 * (tmp85 - tmp92);
		    tmp166 = tmp149 - tmp150;
		    tmp165 = tmp146 - tmp147;
		    tmp148 = tmp146 + tmp147;
		    tmp151 = tmp149 + tmp150;
		    tmp152 = tmp148 + tmp151;
		    tmp174 = K559016994 * (tmp148 - tmp151);
	       }
	  }
	  {
	       fftw_real tmp100;
	       fftw_real tmp156;
	       fftw_real tmp110;
	       fftw_real tmp160;
	       fftw_real tmp103;
	       fftw_real tmp157;
	       fftw_real tmp107;
	       fftw_real tmp159;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp98;
		    fftw_real tmp99;
		    fftw_real tmp108;
		    fftw_real tmp109;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp98 = Y[-2 * iostride];
		    tmp99 = X[7 * iostride];
		    tmp100 = tmp98 - tmp99;
		    tmp156 = tmp98 + tmp99;
		    tmp108 = Y[-iostride];
		    tmp109 = X[6 * iostride];
		    tmp110 = tmp108 - tmp109;
		    tmp160 = tmp108 + tmp109;
	       }
	       {
		    fftw_real tmp101;
		    fftw_real tmp102;
		    fftw_real tmp105;
		    fftw_real tmp106;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp101 = Y[-3 * iostride];
		    tmp102 = X[8 * iostride];
		    tmp103 = tmp101 - tmp102;
		    tmp157 = tmp101 + tmp102;
		    tmp105 = Y[-4 * iostride];
		    tmp106 = X[9 * iostride];
		    tmp107 = tmp105 - tmp106;
		    tmp159 = tmp105 + tmp106;
	       }
	       {
		    fftw_real tmp121;
		    fftw_real tmp122;
		    fftw_real tmp158;
		    fftw_real tmp161;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp104 = tmp100 - tmp103;
		    tmp111 = tmp107 - tmp110;
		    tmp121 = tmp100 + tmp103;
		    tmp122 = tmp107 + tmp110;
		    tmp123 = tmp121 + tmp122;
		    tmp125 = K559016994 * (tmp121 - tmp122);
		    tmp177 = tmp159 + tmp160;
		    tmp176 = tmp156 + tmp157;
		    tmp158 = tmp156 - tmp157;
		    tmp161 = tmp159 - tmp160;
		    tmp162 = tmp158 + tmp161;
		    tmp169 = K559016994 * (tmp158 - tmp161);
	       }
	  }
	  X[0] = tmp78 + tmp93;
	  {
	       fftw_real tmp112;
	       fftw_real tmp134;
	       fftw_real tmp97;
	       fftw_real tmp133;
	       fftw_real tmp138;
	       fftw_real tmp117;
	       fftw_real tmp126;
	       fftw_real tmp137;
	       fftw_real tmp95;
	       fftw_real tmp124;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp112 = (K587785252 * tmp104) - (K951056516 * tmp111);
	       tmp134 = (K951056516 * tmp104) + (K587785252 * tmp111);
	       tmp95 = tmp78 - (K250000000 * tmp93);
	       tmp97 = tmp95 - tmp96;
	       tmp133 = tmp96 + tmp95;
	       tmp138 = (K951056516 * tmp115) + (K587785252 * tmp116);
	       tmp117 = (K587785252 * tmp115) - (K951056516 * tmp116);
	       tmp124 = tmp120 - (K250000000 * tmp123);
	       tmp126 = tmp124 - tmp125;
	       tmp137 = tmp125 + tmp124;
	       {
		    fftw_real tmp113;
		    fftw_real tmp127;
		    fftw_real tmp94;
		    fftw_real tmp114;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp113 = tmp97 - tmp112;
		    tmp127 = tmp117 + tmp126;
		    tmp94 = c_re(W[1]);
		    tmp114 = c_im(W[1]);
		    X[2 * iostride] = (tmp94 * tmp113) + (tmp114 * tmp127);
		    Y[-7 * iostride] = (tmp94 * tmp127) - (tmp114 * tmp113);
	       }
	       {
		    fftw_real tmp129;
		    fftw_real tmp131;
		    fftw_real tmp128;
		    fftw_real tmp130;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp129 = tmp97 + tmp112;
		    tmp131 = tmp126 - tmp117;
		    tmp128 = c_re(W[7]);
		    tmp130 = c_im(W[7]);
		    X[8 * iostride] = (tmp128 * tmp129) + (tmp130 * tmp131);
		    Y[-iostride] = (tmp128 * tmp131) - (tmp130 * tmp129);
	       }
	       {
		    fftw_real tmp135;
		    fftw_real tmp139;
		    fftw_real tmp132;
		    fftw_real tmp136;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp135 = tmp133 + tmp134;
		    tmp139 = tmp137 - tmp138;
		    tmp132 = c_re(W[3]);
		    tmp136 = c_im(W[3]);
		    X[4 * iostride] = (tmp132 * tmp135) + (tmp136 * tmp139);
		    Y[-5 * iostride] = (tmp132 * tmp139) - (tmp136 * tmp135);
	       }
	       {
		    fftw_real tmp141;
		    fftw_real tmp143;
		    fftw_real tmp140;
		    fftw_real tmp142;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp141 = tmp133 - tmp134;
		    tmp143 = tmp138 + tmp137;
		    tmp140 = c_re(W[5]);
		    tmp142 = c_im(W[5]);
		    X[6 * iostride] = (tmp140 * tmp141) + (tmp142 * tmp143);
		    Y[-3 * iostride] = (tmp140 * tmp143) - (tmp142 * tmp141);
	       }
	  }
	  Y[-9 * iostride] = tmp120 + tmp123;
	  {
	       fftw_real tmp153;
	       fftw_real tmp163;
	       fftw_real tmp144;
	       fftw_real tmp154;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp153 = tmp145 + tmp152;
	       tmp163 = tmp155 + tmp162;
	       tmp144 = c_re(W[4]);
	       tmp154 = c_im(W[4]);
	       X[5 * iostride] = (tmp144 * tmp153) + (tmp154 * tmp163);
	       Y[-4 * iostride] = (tmp144 * tmp163) - (tmp154 * tmp153);
	  }
	  {
	       fftw_real tmp167;
	       fftw_real tmp185;
	       fftw_real tmp170;
	       fftw_real tmp186;
	       fftw_real tmp190;
	       fftw_real tmp178;
	       fftw_real tmp175;
	       fftw_real tmp189;
	       fftw_real tmp168;
	       fftw_real tmp173;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp167 = (K587785252 * tmp165) - (K951056516 * tmp166);
	       tmp185 = (K951056516 * tmp165) + (K587785252 * tmp166);
	       tmp168 = tmp155 - (K250000000 * tmp162);
	       tmp170 = tmp168 - tmp169;
	       tmp186 = tmp169 + tmp168;
	       tmp190 = (K951056516 * tmp176) + (K587785252 * tmp177);
	       tmp178 = (K587785252 * tmp176) - (K951056516 * tmp177);
	       tmp173 = tmp145 - (K250000000 * tmp152);
	       tmp175 = tmp173 - tmp174;
	       tmp189 = tmp174 + tmp173;
	       {
		    fftw_real tmp171;
		    fftw_real tmp179;
		    fftw_real tmp164;
		    fftw_real tmp172;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp171 = tmp167 + tmp170;
		    tmp179 = tmp175 - tmp178;
		    tmp164 = c_re(W[6]);
		    tmp172 = c_im(W[6]);
		    Y[-2 * iostride] = (tmp164 * tmp171) - (tmp172 * tmp179);
		    X[7 * iostride] = (tmp172 * tmp171) + (tmp164 * tmp179);
	       }
	       {
		    fftw_real tmp181;
		    fftw_real tmp183;
		    fftw_real tmp180;
		    fftw_real tmp182;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp181 = tmp170 - tmp167;
		    tmp183 = tmp175 + tmp178;
		    tmp180 = c_re(W[2]);
		    tmp182 = c_im(W[2]);
		    Y[-6 * iostride] = (tmp180 * tmp181) - (tmp182 * tmp183);
		    X[3 * iostride] = (tmp182 * tmp181) + (tmp180 * tmp183);
	       }
	       {
		    fftw_real tmp187;
		    fftw_real tmp191;
		    fftw_real tmp184;
		    fftw_real tmp188;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp187 = tmp185 + tmp186;
		    tmp191 = tmp189 - tmp190;
		    tmp184 = c_re(W[0]);
		    tmp188 = c_im(W[0]);
		    Y[-8 * iostride] = (tmp184 * tmp187) - (tmp188 * tmp191);
		    X[iostride] = (tmp188 * tmp187) + (tmp184 * tmp191);
	       }
	       {
		    fftw_real tmp193;
		    fftw_real tmp195;
		    fftw_real tmp192;
		    fftw_real tmp194;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp193 = tmp186 - tmp185;
		    tmp195 = tmp189 + tmp190;
		    tmp192 = c_re(W[8]);
		    tmp194 = c_im(W[8]);
		    Y[0] = (tmp192 * tmp193) - (tmp194 * tmp195);
		    X[9 * iostride] = (tmp194 * tmp193) + (tmp192 * tmp195);
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp21;
	  fftw_real tmp54;
	  fftw_real tmp18;
	  fftw_real tmp22;
	  fftw_real tmp28;
	  fftw_real tmp53;
	  fftw_real tmp55;
	  fftw_real tmp60;
	  fftw_real tmp61;
	  fftw_real tmp43;
	  fftw_real tmp3;
	  fftw_real tmp44;
	  fftw_real tmp25;
	  fftw_real tmp9;
	  fftw_real tmp10;
	  fftw_real tmp11;
	  fftw_real tmp26;
	  fftw_real tmp58;
	  fftw_real tmp45;
	  fftw_real tmp47;
	  fftw_real tmp74;
	  fftw_real tmp75;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp50;
	       fftw_real tmp51;
	       fftw_real tmp52;
	       fftw_real tmp5;
	       fftw_real tmp8;
	       fftw_real tmp4;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp50 = Y[-2 * iostride];
	       tmp51 = K2_000000000 * tmp50;
	       {
		    fftw_real tmp19;
		    fftw_real tmp20;
		    fftw_real tmp16;
		    fftw_real tmp17;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp19 = Y[-4 * iostride];
		    tmp20 = Y[0];
		    tmp21 = tmp19 - tmp20;
		    tmp54 = tmp19 + tmp20;
		    tmp16 = Y[-iostride];
		    tmp17 = Y[-3 * iostride];
		    tmp18 = tmp16 - tmp17;
		    tmp52 = tmp16 + tmp17;
	       }
	       tmp22 = tmp21 - tmp18;
	       tmp28 = tmp18 + tmp21;
	       tmp53 = tmp51 + tmp52;
	       tmp55 = tmp52 + tmp54;
	       tmp60 = K559016994 * (tmp51 - tmp54);
	       tmp61 = (K2_000000000 * (tmp50 - tmp52)) + tmp54;
	       tmp4 = X[2 * iostride];
	       tmp5 = K2_000000000 * tmp4;
	       {
		    fftw_real tmp6;
		    fftw_real tmp7;
		    fftw_real tmp1;
		    fftw_real tmp2;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp6 = X[iostride];
		    tmp7 = X[3 * iostride];
		    tmp8 = tmp6 + tmp7;
		    tmp43 = tmp6 - tmp7;
		    tmp1 = X[0];
		    tmp2 = X[4 * iostride];
		    tmp3 = tmp1 + tmp2;
		    tmp44 = tmp2 - tmp1;
	       }
	       tmp25 = tmp5 - tmp8;
	       tmp9 = tmp5 + tmp8;
	       tmp10 = tmp3 + tmp8;
	       tmp11 = tmp9 + tmp10;
	       tmp26 = tmp3 - tmp8;
	       tmp58 = tmp44 + tmp43;
	       tmp45 = tmp44 - tmp43;
	       tmp47 = tmp45 + tmp43;
	  }
	  X[0] = tmp3 + tmp11;
	  {
	       fftw_real tmp23;
	       fftw_real tmp36;
	       fftw_real tmp31;
	       fftw_real tmp39;
	       fftw_real tmp38;
	       fftw_real tmp27;
	       fftw_real tmp15;
	       fftw_real tmp35;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp30;
		    fftw_real tmp29;
		    fftw_real tmp13;
		    fftw_real tmp14;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp23 = (K951056516 * tmp18) + (K587785252 * tmp22);
		    tmp36 = (K587785252 * tmp18) - (K951056516 * tmp22);
		    tmp30 = K559016994 * (tmp18 + tmp28);
		    tmp29 = tmp21 + (K250000000 * (tmp28 - tmp18));
		    tmp31 = tmp29 + tmp30;
		    tmp39 = tmp30 - tmp29;
		    tmp38 = (K587785252 * tmp25) - (K951056516 * tmp26);
		    tmp27 = (K951056516 * tmp25) + (K587785252 * tmp26);
		    tmp13 = K559016994 * (tmp9 - tmp10);
		    tmp14 = tmp3 - (K250000000 * tmp11);
		    tmp15 = tmp13 + tmp14;
		    tmp35 = tmp14 - tmp13;
	       }
	       {
		    fftw_real tmp12;
		    fftw_real tmp24;
		    fftw_real tmp32;
		    fftw_real tmp33;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp12 = c_re(W[3]);
		    tmp24 = c_im(W[3]);
		    X[4 * iostride] = (tmp12 * (tmp15 + tmp23)) - (tmp24 * (tmp27 + tmp31));
		    tmp32 = c_re(W[5]);
		    tmp33 = c_im(W[5]);
		    X[6 * iostride] = (tmp32 * (tmp15 - tmp23)) + (tmp33 * (tmp27 - tmp31));
	       }
	       {
		    fftw_real tmp34;
		    fftw_real tmp37;
		    fftw_real tmp40;
		    fftw_real tmp41;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp34 = c_re(W[1]);
		    tmp37 = c_im(W[1]);
		    X[2 * iostride] = (tmp34 * (tmp35 - tmp36)) + (tmp37 * (tmp38 + tmp39));
		    tmp40 = c_re(W[7]);
		    tmp41 = c_im(W[7]);
		    X[8 * iostride] = (tmp40 * (tmp35 + tmp36)) + (tmp41 * (tmp39 - tmp38));
	       }
	  }
	  tmp74 = c_re(W[4]);
	  tmp75 = c_im(W[4]);
	  X[5 * iostride] = (tmp74 * (tmp47 - tmp44)) + (tmp75 * (tmp61 + tmp54));
	  {
	       fftw_real tmp56;
	       fftw_real tmp67;
	       fftw_real tmp49;
	       fftw_real tmp68;
	       fftw_real tmp70;
	       fftw_real tmp59;
	       fftw_real tmp63;
	       fftw_real tmp71;
	       fftw_real tmp46;
	       fftw_real tmp48;
	       fftw_real tmp62;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp56 = (K951056516 * tmp53) + (K587785252 * tmp55);
	       tmp67 = (K587785252 * tmp53) - (K951056516 * tmp55);
	       tmp46 = K559016994 * (tmp43 - tmp45);
	       tmp48 = tmp44 + (K250000000 * tmp47);
	       tmp49 = tmp46 - tmp48;
	       tmp68 = tmp46 + tmp48;
	       tmp70 = (K951056516 * tmp58) + (K587785252 * tmp43);
	       tmp59 = (K587785252 * tmp58) - (K951056516 * tmp43);
	       tmp62 = tmp54 - (K250000000 * tmp61);
	       tmp63 = tmp60 + tmp62;
	       tmp71 = tmp62 - tmp60;
	       {
		    fftw_real tmp42;
		    fftw_real tmp57;
		    fftw_real tmp64;
		    fftw_real tmp65;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp42 = c_re(W[0]);
		    tmp57 = c_im(W[0]);
		    X[iostride] = (tmp42 * (tmp49 - tmp56)) + (tmp57 * (tmp59 + tmp63));
		    tmp64 = c_re(W[8]);
		    tmp65 = c_im(W[8]);
		    X[9 * iostride] = (tmp64 * (tmp49 + tmp56)) + (tmp65 * (tmp63 - tmp59));
	       }
	       {
		    fftw_real tmp66;
		    fftw_real tmp69;
		    fftw_real tmp72;
		    fftw_real tmp73;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp66 = c_re(W[2]);
		    tmp69 = c_im(W[2]);
		    X[3 * iostride] = (tmp66 * (tmp67 - tmp68)) + (tmp69 * (tmp70 + tmp71));
		    tmp72 = c_im(W[6]);
		    tmp73 = c_re(W[6]);
		    X[7 * iostride] = (tmp72 * (tmp71 - tmp70)) - (tmp73 * (tmp68 + tmp67));
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7, 8, 9};
fftw_codelet_desc fftw_hc2hc_backward_10_desc =
{
     "fftw_hc2hc_backward_10",
     (void (*)()) fftw_hc2hc_backward_10,
     10,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     171,
     9,
     twiddle_order,
};
