/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * memory.c
 */

/*
 * Create MEMORY postmaster object
 */
#include <stdio.h>
#include <constants.h>
#include <defaults.h>
#include <pm.h>
#include <memory.h>

static char *MEMORY_OBJ_NAME = "Memory";

static char *MEMORY[] = {
  "Memory.Sel_Pt", "Memory.Param", "Memory.Count", "Memory.Points",
  "Memory.Reset"
  };

typedef enum {
  SEL_PT=0, PARAM, COUNT, POINTS, RESET
  } MEMORY_t;


void
memory_install()
{
  void memory_count(), memory_reset();

  pm(CREATE_OBJ, MEMORY_OBJ_NAME,
     CREATE_ELEM, MEMORY[SEL_PT], MEMRY,
     CREATE_ELEM, MEMORY[PARAM], MEMRY,
     CREATE_ELEM, MEMORY[COUNT], FNCT,
     CREATE_ELEM, MEMORY[RESET], FNCT,
     CREATE_ELEM, MEMORY[POINTS], INT,
     NULL);

  pm(INIT, MEMORY[COUNT],
     PUT, MEMORY[COUNT], memory_count,
     INIT, MEMORY[RESET],
     PUT, MEMORY[RESET], memory_reset,
     NULL);
}

void
memory_reset()
{
  pm(INIT, MEMORY[SEL_PT], SEL_PT_MEMORY,
     INIT, MEMORY[PARAM], PARAM_MEMORY,
     EXEC, MEMORY[COUNT],
     NULL);
  
}

void
memory_count()
{
  char *name;
  memory m;
  int i=0, n=0;

  while ( (name = (char *) pm(QUERY, "Memory", MEMRY, i, NULL)) )
    {
      i++;
      m = (memory) pm(GET, name, NULL);
      n += memory_stored_points(m);
    }

  pm(PUT, MEMORY[POINTS], n, NULL);
}
