/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * cont_state.c
 * 
 * Routines used by the cont_state panel to update information
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pm.h>
#include <math.h>
#include <defaults.h>
#include <eigen.h>
#include <symbols.h>
#include <constants.h>
/*#include "continue_def.h" */
#include <continue.h> 
#include <memory.h>
#include <math_utils.h>
#include <modellib.h>
#include <view.h>

#define WORK_SIZE 1000

/*
void cont_get_state(void);
void cont_copy_state(void);
void cont_compute_functions(void);
int cont_get_ews(void);
 
extern int cont_setup();
extern int cont_exit();   */


extern struct  Cont_Cntl_Ds            cont_ds;

/* 
 * cont_get_state()
 *
 * Gets state information from Cont memory
 * 
 */

void 
cont_get_state()
{
    memory m = (memory) pm(GET, "Memory.Continuation", NULL);

    int set_code = 0;
    int n_varb, n_param, n_flows, n_trajs, n_points, status, *p_bi;
    double *p_varb, *p_param, *p_bd;

    pm(PUT, "Cont.Set_Code", 0, NULL);
    if (m == NULL) 
        return;
    
    n_varb = *((int *) pm(GET, "Model.Varb_Dim", NULL));
    n_param = *((int *) pm(GET, "Model.Param_Dim", NULL));
/*   
    p_varb = dvector(0,n_varb-1);
    p_param = dvector(0,n_param-1);
 */ 

    n_flows = memory_nflows(m);
    n_trajs = memory_ntrajs(m,n_flows);
    n_points = memory_npoints(m,n_flows,n_trajs);

    status = memory_set_read(m,n_flows,n_trajs,n_points, 
                             NULL, NULL, NULL, NULL, NULL, NULL);
    if (status) return;
 
    status = memory_read_next_point(m, &p_varb, &p_param, NULL,
                                    &p_bd, &p_bi);
 /*
    if (p_varb)
      {
        pm(PUT_LIST, "Cont.Varb_Fc", 0, n_varb-1, p_varb, NULL);
     
        set_code += 1;
      }
 
    if (p_param)
      {
         pm(PUT_LIST, "Cont.Param_Fc", 0, n_param-1, p_param, NULL);
    
        set_code += 2;
      }
 
    pm(GET_LIST, "Cont.Varb_Fc", 0, n_varb-1, p_varb, NULL);
    pm(GET_LIST, "Cont.Param_Fc", 0, n_param-1, p_param, NULL);
 */
    pm(EXEC, "Cont.Compute_Functions", NULL);
    if (p_varb)
        set_code += 1;
    if (p_param)
        set_code += 2;
/*
    free_dvector(p_varb,0,n_varb-1);
    free_dvector(p_param,0,n_param-1);
 */


    pm(PUT, "Cont.Set_Code", set_code, NULL);
} 



/* 
 * cont_copy_state 
 * 
 * Copies current info from cont_state panel into Selected memory
 * 
 */

void
cont_copy_state()
{
  int i, n, code;
  
  code = *((int *) pm(GET, "Cont.Set_Code", NULL));
 
  if (code & 1)
    {
      /* do variables */
      n = *((int *) pm(GET, "Model.Varb_Dim", NULL));
      for (i=0; i<n; i++)
        pm(PUT, "Selected.Varb_Ic", i,
           *((double *) pm(GET, "Cont.Varb_Fc", i, NULL)), NULL);
    }
  if (code & 2)
    {
      /* do parameters */
      n = *((int *) pm(GET, "Model.Param_Dim", NULL));
      for (i=0; i<n; i++)
        pm(PUT, "Selected.Param_Ic", i,
           *((double *) pm(GET, "Cont.Param_Fc", i, NULL)), NULL);
    }
  pm(EXEC, "Cont.Compute_Functions", NULL);
}



void
cont_compute_functions()
{
  int vdim, pdim, fdim;
  double *func, *varb, *param;
 
  fdim = *((int *) pm(GET, "Model.Funct_Dim", NULL)); 
  if (fdim==0) return;
 
  vdim = *((int *) pm(GET, "Model.Varb_Dim", NULL));
  pdim = *((int *) pm(GET, "Model.Param_Dim", NULL));
 
  func = dvector(0,fdim-1);
  varb = dvector(0,vdim-1);
  param = dvector(0,pdim-1);
 
  pm(GET_LIST, "Cont.Varb_Fc", 0, vdim-1, varb, NULL);
  pm(GET_LIST, "Cont.Param_Fc", 0, pdim-1, param, NULL); 
  get_ds_func(func, varb, param);
  pm(PUT_LIST, "Cont.Funct_Fc", 0, fdim-1, func, NULL);
 
  free_dvector(varb,0,vdim-1);
  free_dvector(param,0,pdim-1);
  free_dvector(func,0,fdim-1);
}
 

/* 
 * cont_get_ews 
 * 
 * Get eigenvalues of jacobian matrix for current equilibrium point
 * 
 */

int
cont_get_ews()
{
     int i, ierror, index;
     char strng[MAX_LONG_STR];
     char rl[MAX_LONG_STR], imag[MAX_LONG_STR];
     double *state, *parameters, **jac2;
     double  *wr, *wi;
     
     int   n_varb = *((int *) pm(GET, "Model.Varb_Dim", NULL)) - 1;
     int   n_param = *((int *) pm(GET, "Model.Param_Dim", NULL));
     int   format = *((int *) pm(GET, "Defaults.Precision", NULL));

     cont_setup();
     if ( ! (state = dvector(0,n_varb)) ) return(-1);
     if ( ! (parameters = dvector(0,n_param))  ) return(-1);
 
     pm( GET_LIST, "Cont.Varb_Fc", 0, n_varb-1, state, NULL);
     pm( GET_LIST, "Cont.Param_Fc", 0, n_param-1, parameters, NULL);
     wr = dvector(0,n_varb);
     wi = dvector(0,n_varb);
     jac2 = dmatrix(0,n_varb+1,0,n_varb+1);

     get_Dxf( jac2, n_varb, state, parameters );

     get_eigenval(jac2,n_varb,wr,wi);

/* Put the info in the postmaster: string formats changed 6/19/97 BAM */ 
     for(i=0; i<n_varb; i++)
       {
        sprintf(rl, "%.*f", format, wr[i]);
        sprintf(imag, "%.*f", format, wi[i]);
        sprintf(strng,"(%s",rl);
        index = (int) strspn(imag,"0123456789-+E.");
        strcat(strng," + ");
        strncat(strng,imag,index+1);
        strcat(strng," i )");
        pm(PUT,"Cont.Ews",i,strng); 
       }
     free_dvector(wr,0,n_varb);
     free_dvector(wi,0,n_varb);
     free_dmatrix(jac2,0,n_varb+1,0,n_varb+1);
     free_dvector(state,0,n_varb);
     free_dvector(parameters,0,n_param);

 /* Free memory from cont_setup  (cf cont_exit) */
     free_ivector(cont_ds.manifold->periodic_varb,0,n_varb); 
     free_dvector(cont_ds.manifold->period_start,0,n_varb);
     free_dvector(cont_ds.manifold->period_end,0,n_varb);
     free(cont_ds.manifold);
     
     return 1;

}
 
 
