/*
 * =========================================================================
 * block_opt - A program to add newlines to an optional-format USGS DLG file.
 * Copyright (c) 1997  Fred M. Erickson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * =========================================================================
 *
 * This program blocks the information in an optional-format DLG file
 * by adding a newline after each record.  (Records are
 * a multiple of 80 bytes.)
 *
 * The program reads from stdin and writes to stdout.
 */
#include <stdio.h>

main()
{
	unsigned char buf[80];
	int start_flag = 0;
	unsigned char nl = '\n';
	int ret_val;

	while ((ret_val = read(0, buf, 80)) > 0)  {
/*		if ((buf[0] >= 'A') && (buf[0] <= 'Z'))  { */
			if (start_flag != 0)  {
				write(1, &nl, 1);
			}
			else  {
				start_flag = 1;
			}
			write(1, buf, ret_val);
/*		} */
	}
	write(1, &nl, 1);

	if ((ret_val != 0) && (ret_val != 80))  {
		fprintf(stderr, "read() returned %d\n", ret_val);
		exit(0);
	}
}
