#include "test_I.h"

int test_I_xgcd (int iterations)
{
	int error = 0;
	int i;
	// Check against gcd.
	for (i = iterations; i > 0; i--) {
		cl_I a = testrandom_I();
		cl_I b = testrandom_I();
		cl_I u, v;
		cl_I g = xgcd(a,b,&u,&v);
		ASSERT2(g == gcd(a,b), a,b);
		ASSERT2(g == u*a+v*b, a,b);
		if (a != 0 && b != 0) {
			if (abs(a) == abs(b)) {
				ASSERT2((u == signum(a) && v == 0) || (u == 0 && v == signum(b)), a,b);
			}
			else if (mod(abs(a),abs(b)) == 0) {
				ASSERT2(u == 0 && v == signum(b), a,b);
			}
			else if (mod(abs(b),abs(a)) == 0) {
				ASSERT2(u == signum(a) && v == 0, a,b);
			}
			else {
				#if 0 // why is this not true ??
				ASSERT2(abs(u) <= floor1(abs(b),2*g) && abs(v) <= floor1(abs(a),2*g), a,b);
				#else
				ASSERT2(abs(u) <= floor1(abs(b),g) && abs(v) <= floor1(abs(a),g), a,b);
				#endif
			}
		}
	}
	return error;
}
