// ftruncate2().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_real.h"


// Implementation.

#include "cl_R.h"

cl_R_fdiv_t ftruncate2 (const cl_R& x, const cl_R& y)
{
// Methode:
// x,y beide rational: truncate(x,y), Quotienten in Float umwandeln.
// Sonst: ftruncate(x/y) -> q,r. Liefere die Werte q und x-y*q = y*r.
	if (rationalp(x))
		if (rationalp(y)) {
			// beides rationale Zahlen
			DeclareType(cl_RA,x);
			DeclareType(cl_RA,y);
			var cl_R_div_t q_r = truncate2(x,y);
			var cl_I& q = q_r.quotient;
			var cl_R& r = q_r.remainder;
			return cl_R_fdiv_t(cl_float(q),r);
		}
	var cl_R_fdiv_t q_r = ftruncate2(x/y);
	var cl_F& q = q_r.quotient;
	var cl_R& r = q_r.remainder;
	return cl_R_fdiv_t(q,y*r);
}
