// $Id: tcl_interf.hh,v 1.13 1998/10/25 23:38:33 cthulhu Exp $


#ifndef _TCL_INTERF_DOT_HH_
#define _TCL_INTERF_DOT_HH_

extern "C" {
#include "tcl.h"
#include "tk.h"
}
#include "utils.hh"
#include "stdlib.h"
#include "cell.hh"
#include "calc.hh"
#include "sheet.hh"
#include "checkargs.hh"
#include "event.hh"
#include "sort.hh"
#include "canvas.hh"
#include "format.hh"

#define COLUMN 0
#define ROW 1

#define PASTE_ALL 0
#define PASTE_FORMULAS 1
#define PASTE_VALUES 2
#define PASTE_FORMATS 3

#define PASTE_NONE 0
#define PASTE_ADD 1
#define PASTE_SUB 2
#define PASTE_MUL 3
#define PASTE_DIV 4

extern int sort_dir;

typedef enum { FORMAT, ALIGNMENT, FONT_FAMILY, SIZE, ITALICS, BOLD, TOP,
	       BOTTOM, LEFT, RIGHT, BG } CR_Formats;

Sheet *CreateSheet(char *name,Tcl_Interp *interp) ;
Sheet *SheetFromName(char *name);
void copy_to_paste_buffer(Sheet *sheet, short ci, short ri, 
                          short cf, short rf);
void paste(Sheet *sheet, short ci, short ri, 
                          short cf, short rf,int what, int how);
void range_kill(Sheet *sheet, short ci, short ri, 
                          short cf, short rf);


extern "C" {
    int Xxl_CanvasCmd(ClientData clientData, Tcl_Interp *interp, 
                    int argc, char **argv);
}

#endif

// $Log: tcl_interf.hh,v $
// Revision 1.13  1998/10/25 23:38:33  cthulhu
// Moved auxiliary functions to interf_aux.
//
// Revision 1.12  1998/09/29 00:58:35  cthulhu
// Paste now accepts two arguments, to indicate if it should paste formulas, all,
// values or formats (what) and if it should do nothing, add, subtract, multiply
// or divide the target and the source (how).
//
// Revision 1.11  1998/09/03 17:53:06  cthulhu
// Added checkargs.hh to include list to check incoming arguments of exported
// functions
//
// Revision 1.10  1998/08/06 21:08:55  aml
// Released alpha version of Abacus.
//
// Revision 1.9  1997/01/07 01:07:53  aml
// Error propagation for formulas fixed.
// Edit operations in place.
//
//Revision 1.8  1996/04/21  13:29:03  aml
//Sped up scroll functions, caching keys presses.
//First cut at handling overflowing cells.
//Overflow into ajoining filled cells not solved.
//
//Revision 1.7  1996/04/19  10:46:50  aml
//First cut at speeding up canvas critical functions.
//CanvasWidgetCommand is now called directly from draw_sheet.
//Fixed bug in reading values from datafiles. Also works
//for Suns now.
//Created canvas directory, replacing builtin command canvas.
//
//Revision 1.6  1996/03/06  20:25:43  aml
//Improved user waiting times during redraw and loads by calling update.
//
// Revision 1.5  1996/02/19 15:47:48  aml
// Fixed abnormality with mouse click.
// Variable width columns implemented, but not yet saved.
// Labels are now a lex element, fixing some aberrant behavior that existed.
//
// Revision 1.4  1996/02/13 12:04:04  aml
// Fixed bug with range definition via mouse.
// Fixed bug in range iterators.
//
// Revision 1.3  1996/01/05 23:06:11  aml
// Cell references evaluated.
// Spreadsheet is recalculated at every change, by an arbitrary order.
// Reformulated program structure. Evaluation and reverse parsing
// are member functions of Sheet.
//
//Revision 1.2  1995/12/13  14:34:02  aml
//*** empty log message ***
//
//Revision 1.1  1995/12/13  12:46:15  aml
//Initial revision
//
