#
# This function receives a canvas and reads a global var named lst
# in order to execute each element of that list by pressing the key
# Return.
#

proc EvaluateScriptList {c} {

    global lst
    global ended
    global demo

    set tmp [bind $c <Key-Return>]
    set tmp2 [bind $c <Key-Escape>]
    set tmp3 [bind $c <Key-space>]
    set ended false

    bind $c <Key-Return> { 
	global lst
	global ended
	if { [llength $lst]>0 } {		    
	    eval [lindex $lst 0];
	    set lst [lrange $lst 1 [llength $lst]];
	} else {
	    if { [llength $lst]==1 } {		    
		eval [lindex $lst 0];
		set lst {}
	    }
	    set ended true
	}
    }

    bind $c <Key-Escape> {
	set ended true
    }

    bind $c <Key-space> {}
    
    tkwait variable ended
    
    bind $c <Key-Return> $tmp
    bind $c <Key-Escape> $tmp2
    bind $c <Key-space> $tmp3
    
}

#
# Each element of the following list "slides" contains the information that
# should be used by abacus-presentation.tcl to present each slide.
#

set slides { 
    {Presentation slide1 picture xxl.gif "Projecto ABACUS 1997/1998" "Instituto Superior Tecnico"}

    {
	Presentation slide0 text { 
	    {"\tMotivao\n" l left}
	    {"\tPlataforma GNU/Linux no tem folhas de clculo com qualidade." \
		 m left}
	    {"\tExistentes tm funcionalidade limitada.\n" m left}
	    {"\tPlataforma interessante\n" l left}
	    {"\tLinux" m left}
	    {"\tXWindows\n" m left}
	    {"\tPromoo de tecnologias e mtodos recentes\n" l left}
	    {"\tPromover Tcl/Tk." m left}
	    {"\tDesenvolvimento apoiado pela comunidade GNU/Linux." m left}
	} "Introduo"
    } 
    {
	Presentation slide1 text {
	    {"\tDiviso em dois subsistemas principais:\n" l left}
	    {"\tTcl/Tk:" m left}
	    {"\tInterface utilizador." s left}
	    {"\tProcessamento \"leve\".\n" s left}
	    {"\tC/C++:" m left}
	    {"\tRotinas de clculo." s left}
	    {"\tInterface com SO." s left}
	    {"\tProcessamento \"pesado\"." s left}
	} "Introduo" "Viso geral arquitectura"
    }
    {
	Presentation slide2 text {
	    {"\tEvoluo do prottipo inicial:" l left}
	    {"\tUpgrade para verses mais recentes bibliotecas." m left}
	    {"\tReviso funcionalidade j existente." m left}
	    {"\tImplementao funcionalidade bsica.\n" m left}
	    {"\tVerso alfa:" l left}
	    {"\tImplementao verso bsica de ideias futuras." m left}
	    {"\tDistruibuio pela Internet do cdigo fonte.\n" m left}
	    {"\tMelhoramento verso incial:" l left}
	    {"\tFuncionalidades avanadas." m left}
	    {"\tResposta a feedback dos utilizadores.\n" m left}
	    {"\tSegunda verso" l left}
	    {"\t..." m left}
	} "Introduo" "Fases desenvolvimento"
    }
    {
	Presentation slide3 text {
	    {"\tLinux\n" l left}
	    {"\tFerramentas GNU\n" l left}
	    {"\tXWindows\n" l left}
	    {"\tTcl/Tk\n" l left}
	} "Introduo" "Ambiente de trabalho"
    }
    {
	Presentation slide4 text {
	    {"\tComputao Grfica:" l left}
	    {"\tInterface." m left}
	    {"\tProgramao usando sistema de janelas.\n" m left}
	    {"\tInterfaces Homem-Mquina:" l left}
	    {"\tFacilidade de utilizao.\n" m left}
	    {"\tProgramao com Objectos:" l left}
	    {"\tHierarquias de objectos - desenho." m left}
	    {"\tImplementao em C++.\n" m left}
	    {"\tEngenharia da Programao:" l left}
	    {"\tMetodologia de desenvolvimento/engenharia adoptada." m left}
	    {"\tProduo de documentao (tambm para esta apresentao!).\n" m left}
	    {"\t..." l left}
	} "Introduo" "Conceitos Utilizados"
    }
    {
	Presentation slide5 text {
	    {"\tQuando surgiu software \"livre\"?" l left}
	    {"\tNo incio:" m left}
	    {"\tProgramadores na \"pr-histria\" trocavam programas...\n" s left}
	    {"\t... e actualmente?" l left}
	    {"\tComunidade \"Internetiana\"." m left}
	    {"\tDentro das prprias firmas que vendem software!\n" m left}
	    {"\tSer nica maneira de obter qualidade real?" l left}
	    {"\tProgramas comerciais tm bugs..." m left}
	    {"\tSoluo perfeita no existe..." m left}
	} "Conceitos Bsicos" "GNU, Linux - \"software livre\""
    }
    {
	Presentation slide6 text {
	    {"\tMas, paga-se?" l left}
	    {"\tTalvez sim, talvez no.\n" m left}
	    {"\tE ento a minha liberdade?" l left}
	    {"\tEstudar como o programa funciona atravs do cdigo." m left}
	    {"\tLiberdade de poder dar o programa ao vizinho sem quebrar a lei." m left}
	    {"\tMelhorar o programa e distribuir para o pblico...\n" m left}
	    {"\t...Benefico para a comunidade!\n" l left}
	} "Conceitos Bsicos" "GNU, Linux - \"software livre\""
    }
    {
	Presentation slide7 text {
	    {"\tHistria\n" l left}
	    {"\tGNU" m left}
	    {"\tIncio em 1985." s left}
	    {"\tComea com o Emacs, gcc, linker, debugger...no comea mal." s left}
	    {"\tGNU Manifesto - Stallman apela  comunidade.\n" s left}
	    {"\tLinux" m left}
	    {"\tIncio em 1991." s left}
	    {"\tEvoluo do Minix." s left}
	    {"\tActualmente 7 milhes utilizadores.\n" s left}
	    {"\tEm comum...Internet\n" l left}
	} "Conceitos Bsicos" "GNU, Linux - \"software livre\""
    }
    {
	Presentation slide8 text {
	    {"\tComo surge?\n" l left}
	    {"\tEm Berkeley, Ousterhout precisava de intergrar ferramentas diferentes." m left}
	    {"\tMas cada ferramenta tinha uma linguagem diferente!\n" m left}
	    {"\tCaracteristcas da ferramenta a usar para fazer integrao:" m left}
	    {"\tLinguagem interpretada." s left}
	    {"\tEstruturas de controlo genricas - fazer a \"ponte\" entre aplicaes diferentes." s left}
	    {"\tProcedimentos.\n" s left}
	    {"\tObjectivos:" m left}
	    {"\tExtensvel: Cada aplicao deve adicionar componentes novas fcil e naturalmente." s left}
	    {"\tLinguagem simples e genrica - no restringir \"clientela\"." s left}
	    {"\tObjectivo principal no  \"fazer\" mas \"colar\".\n" s left}
	    {"\tNasce o Tcl (Tool Command Language)." m left}
	} "Conceitos Bsicos" "Tcl e Tk"
    }
    {
	Presentation slide9 text {
	    {"\tEm 88 surge necessidade de criar GUI especfico:\n" l left}
	    {"\tCada vez mais populares." m left}
	    {"\tTempo de desenvolvimento cada vez mais longo." m left}
	    {"\tNecessidade de implementao rpida." m left}
	    {"\tReaproveitamento de componentes j realizadas vital." m left}
	    {"\tAgregar componentes desenvolvidas por equipas pequenas para sistemas grandes.\n" m left}
	    {"\tO que usar para integrar estes componentes...Tcl!\n" m left}
	    {"\tO que falta? Componentes de GUI para Tcl...\n" m left}
	    {"\tNasce o Tk!\n" l left}
	    {"\tExtenso do Tcl para construir interfaces grficas com utilizador." m left}
	} "Conceitos Bsicos" "Tcl e Tk"
    }
    {
	Presentation slide10 text {
	    {"\tSucesso do Tk?" l left}
	    {"\tSimples e poderoso." m left}
	    {"\tOutros Toolkits (Motif, etc) muito complexos." m left}
	    {"\tTempo de desenvolvimento rpido.\n" m left}
	    {"\tSucesso do Tcl?" l left}
	    {"\tCapacidade de integrao." m left}
	    {"\tToda a gente quer usar scripts nas suas aplicaes..." m left}
	    {"\t...ningum tem tempo para desenvolver linguagem..." m left}
	    {"\t...adoptam Tcl.\n" m left}
	    {"\tPresente:" l left}
	    {"\tAmbiente multi-plataforma - suporte para Win e Mac." m left}
	    {"\tProteco - SafeTcl." m left}
	    {"\tCompilador Bytecodes - \"moda\" em linguagens interpretadas." m left}
	    {"\tIntegrao com Java." m left}
	    {"\t..." m left}
	} "Conceitos Bsicos" "Tcl e Tk"
    }
    {
	Presentation slide11 text {
	    {"\tO Passado\n" l left}
	    {"\tVisicalc" m left}
	    {"\tDan Bricklin foi o criador em 1978 - MIT." s left}
	    {"\t5 linhas por 20 colunas. (!)\n" s left}
	    {"\tLotus 1-2-3" m left}
	    {"\tInventado Mitch Kapor em 1980." s left}
	    {"\tConveno para nomes clulas formato A1 em vez de C1R1." s left}
	    {"\tGrficos." s left}
	    {"\tGrupos de clulas - \"Ranges\"." s left}
	    {"\tMacros.\n" s left}
	    {"\tExcel" m left}
	    {"\tUsa rato para interaco com utilizador." s left}
	    {"\tUsa interface puramente grfica." s left}
	} "Conceitos Bsicos" "Folhas de clculo"
    }
    {
	Presentation slide12 text {
	    {"\tO Presente\n" l left}
	    {"\tExcel" l left}
	    {"\tInterface amigvel." m left}
	    {"\tGrau de customizao elevado - tudo  formatvel." m left}
	    {"\tVisual Basic para macros -  macros tm componente GUI.\n" m left}
	    {"\tMas...quais as inovaes principais?" l left}
	    {"\tConfigurabilidade total." m left}
	    {"\tIntegrao com outras aplicaes - o \"Office\"." m left}
	} "Conceitos Bsicos" "Folhas de clculo"
    }
    {
	Presentation slide13 text {
	    {"\tO Futuro\n" l left}
	    {"\tEvoluo tem sido orientada para capacidades de apresentao...\n" m left}
	    {"\tQuais os problemas actuais?" m left}
	    {"\tEncorajam problemas com muitas referncias no ordenadas entre clulas." s left}
	    {"\tDemasiado complexo verificar se esto ou no correctas - verificar clula a clula..." s left}
	    {"\tNo so adequadas como repositrios de informao, embora sejam convenientes.\n" s left}
	    {"\tO que  que gostvamos de ter?" m left}
	    {"\tAuditar dados e verificar correco fcilmente." s left}
	    {"\tManter informao de forma centralizada.\n" s left}
	    {"\tSoluo" m left}
	    {"\tUsar folha de clculo para gerar relatrios e base de dados para guardar dados." s left}
	} "Conceitos Bsicos" "Folhas de clculo"
    }
    {
	Presentation slide14 picture modelo_em_espiral.gif \
	    "Metodologia" "Modelo em Espiral"}
    {
	Presentation slide15 text {
	    {"\tFase inicial de desenvolvimento do Abacus\n" l left}
	    {"\tCalendarizao planeada desde incio." m left}
	    {"\tParadigma mais realista." m left}
	    {"\tIntroduz anlise de risco." m left}
	    {"\t(neste caso controla um recurso critco - tempo)." s left}
	    {"\tAdopta outros modelos de engenharia no quadrante de desenvolvmento.\n" m left}
	    {"\tMas...qual o modelo aps distribuio do cdigo?" l left}
	} "Metodologia" "Modelo em espiral"
    }
    {
	Presentation slide15 text {
	    {"\tEstilo de desenvolvimento clssico" l left}
	    {"\tDesenho cuidadoso." m left}
	    {"\tEquipa de especialistas a trabalhar isoladamente." m left}
	    {"\tViso \"Catedral\".\n" m left}
	    {"\tMas...como fizeram GNU e Linux?" l left}
	    {"\tReleases o mais cedo possvel." m left}
	    {"\tDelegar nos utilizadores tarefas de implementao." m left}
	    {"\tQualquer um pode participar...desde que saiba." m left}
	    {"\tDesenvolvimento  feito \"porta aberta\"." m left}
	    {"\tViso \"Bazar\".\n" m left}
	    {"\tQuais os principos subjacentes?" l left}
	} "Metodologia" "Modelo \"bazar\""
    }
    {
	Presentation slide16 text {
	    {"Motivao do programador" l left}
	    {"Quem programa por gosto, no s no se cansa, tambm o faz melhor.\n" m left}
	    {"Soluo parcial  melhor do que fazer tudo de uma vez" l left}
	    {"A partir dela pode ser que algum aparea e faa o resto...\n" m left}
	    {"Capacidade de retornar ao incio do desenvolvimento." l left}
	    {"Do exterior pode apareer melhor do que o que j temos...\n" m left}
	    {"E se perdemos o interesse?" l left}
	    {"Entregar projecto a sucessor competente.\n" m left}
	    {"No entanto, como motivar os utilizadores a participar?" l left}
	} "Metodologia" "Modelo \"bazar\""
    }
    {
	Presentation slide17 text {
	    {"\"Release early, Release often\"\n" l left}
	    {"Utilizadores vm seus problemas a serem resolvidos.\n" m left}
	    {"Na prtica  \"cham-los\" para trabalharem no projecto.\n" m left}
	    {"Mas...e os bugs?" m left}
	    {"Devemos parar at estarem todos corrigidos?" s left}
	    {"No? Porque...\n" s left}
	    {"...dotados de uma gama de utilizadores suficientemente vasta, soluo  sempre bvia para algum." m left}
	    {"(e em geral quem descobre no  a mesma pessoa que corrige e ambas ocorrem muito rpidamente).\n" s left}
	    {"Na prtica, mais verses significam mais correces..." m left}
	    {"...e trabalho de debug no  duplicado j que correco  logo disponibilidada!" m left}
	} "Metodologia" "Modelo \"bazar\""
    }
    {
	Presentation slide18 text {
	    {"O cdigo mais simples  sempre o melhor" l left}
	    {"Se no se percebe no se consegue explicar aos outros." m left}
	    {"Documentar estimula a participao exterior." m left}
	    {"Potencial programador no deve ver esforos iniciais gorados.\n" m left}
	    {"Tratar utilizadores como recurso mais valioso" l left}
	    {"Porque de facto o so!" m left}
	    {"Criar mail lists para utilizadores." m left}
	    {"Fazer com que utilizadores se registem." m left}
	    {"Estimular troca de ideias entre interessados.\n" m left}
	    {"Reconheer ideias dos utilizadores" l left}
	    {"Utilizadores \"guiam-nos\" na direco certa de desenvolvimento." m left}
	} "Metodologia" "Modelo \"bazar\""
    }
    {
	Presentation slide19 text {
	    {"Mas, como comear?" l left}
	    {"Utilizar outro modelo de desenvolvimento at ter alguma coisa feita." m left}
	    {"Verso inicial deve prometer mais do que fazer - viso para o futuro.\n" m left}
	    {" mais importante o coordenador que o desenhador" l left}
	    {"Melhor este saber orientar esforo do que produzi-lo.\n" m left}
	    {"Mtodo capta \"massa cinzenta\" de centenas de pessoas" l left}
	    {"Outras metodologias so melhores em ambientes fechados..." m left}
	    {"...mas com comunidade inteira modelo  melhor que qualquer outro.\n" m left}
	    {"Qual o requisito principal?\n" l left}
	    {"Meio de comunicao como Internet!" l left}
	} "Metodologia" "Modelo \"bazar\""
    }
    {
	Presentation slide20 text {
 	    {"Mas, como comear?" l left}
	    {"Utilizar outro modelo de desenvolvimento at ter alguma coisa feita." m left}
	    {"Verso inicial deve prometer mais do que fazer - viso para o futuro.\n" m left}
	    {" mais importante o coordenador que o desenhador" l left}
	    {"Melhor este saber orientar esforo do que produzi-lo.\n" m left}
	    {"Mtodo capta \"massa cinzenta\" de centenas de pessoas" l left}
	    {"Outras metodologias so melhores em ambientes fechados..." m left}
	    {"...mas com comunidade inteira modelo  melhor que qualquer outro.\n" m left}
	    {"Qual o requisito principal?\n" l left}
	    {"Meio de comunicao como Internet!" l left}
	} "Metodologia" "Modelo \"bazar\""
    }
    {
	Presentation slide21 picture arquitectura_do_abacus.gif \
	    "Tcnicas" "Arquitectura - viso global"
    }
    {
	Presentation slide22 text {
	    {"Widget Tk optimizado para o Abacus.\n" l left}
	    {"Porqu alterao?" l left}
	    {"Canvas originalmente pensado para conter poucos elementos grficos...\n" m left}
	    {"Soluo passa pela criao de tipos de elementos especiais.\n" l left}
	    {"Funes de desenho s redesenham elementos necessrios.\n" l left}
	    {" a melhor soluo?" l left}
	    {"No - optimizao seguinte seria deixar de usar listas internas para conter objectos." m left}
	} "Tcnicas" "Arquitectura - Canvas"
    }
    {
	Presentation slide23 text {
	    {"Controla toda a interaco com utilizador.\n" l left}
	    {"Gera ambiente de trabalho WYSIWYG.\n" l left}
	    {"Implementado inteiramente em Tk.\n" l left}
	    {"Tcl usado para controlar mquina de estados da interface." l left}
	    {"Realizado atravs de trs variveis de estado...\n" m left}
	    {"Resumidamente - Implementa \"Look and Feel\".\n" l left}
	    {"Tarefas \"pesadas\" so delegadas para camada inferior.\n" l left}
	} "Tcnicas" "Arquitectura - Display"
    }
    {
	Presentation slide24 picture display.gif \
	    "Tcnicas" "Arquitectura - Display"
    }
    {
	Presentation slide25 picture globalstate1.gif \
	    "Tcnicas" "Arquitectura - Display"
    }
    {
	Presentation slide26 picture globalstate2.gif \
	    "Tcnicas" "Arquitectura - Display"
    }
    {
	Presentation slide27 picture globalstate3.gif \
	    "Tcnicas" "Arquitectura - Display"
    }
    {
	Presentation slide28 text {
	    {"Sistema documentao interno\n" l left}
	    {"Visualizador de documentao." m left}
	    {"Criao de browser em Tk." s left}
	    {"Gerao de ficheiros com informao para serem lidos pelo browser." s left}
	    {"Acesso via browser externo a pginas de Web.\n" m left}
	    {"Aumento de usabilidade do programa\n" l left}
	    {"rea de mensagens para utilizador." m left}
	    {"Tooltips.\n" m left}
	    {"Man-page" l left}
	} "Tcnicas" "Arquitectura - Help"
    }
    {
	Presentation slide29 picture demo-help.gif \
	    "Tcnicas" "Arquitectura - Help"
    }
    {
	Presentation slide30 text {
	    {"Comandos exportados so os utilizados para criar Abacus!" l left}
	    {"Realizado atravs de cdigo C que  incorporado no interpretador Tcl." m left}
	    {"Existe um interpretador associado a cada sheet.\n" m left}
	    {"O utilizador  livre de incorporar novas funcionalidades.\n" l left}
	    {"Exportam-se comandos que manipulam a folha.\n" l left}
	    {"Scripts so fceis de escrever.\n" l left}
	    {"Exemplo: Esta apresentao!" l left}
	    {"Script com 200 linhas!!! (com Motif nem pensar!)" m left}
	} "Tcnicas" "Arquitectura - Macros"
    }
    {
	Presentation slide31 text {
	    {"Realizados totalmente em Tk.\n" l left}
	    {"Cada tipo de grfico  um script diferente." l left}
	    {"Na inicializao  feita leitura de directoria de scripts.\n" m left}
	    {"Relao com \"core\" de clculo C existe para criar dependncias." l left}
	} "Tcnicas" "Arquitectura - Grficos"
    }
    {
	Presentation slide32 text {
	    {"Implementa hierarquia de objectos interna." l left}
	    {"Disponibiliza funes Tcl para efectuar sua manipulao.\n" m left}
	    {"Objecto sheet centraliza operaes:" l left}
	    {"Clulas armazenadas em Hash Table." m left}
	    {"Formatos associados a clulas e sheets (para linhas e colunas)." m left}
	    {"Controla lista de dependncias entre clulas." m left}
	    {"Tem interpretador Tcl associado.\n" m left}
	    {"Realiza interface com SO para gravar e ler folhas.\n" l left}
	    {"..." l left}
	} "Tcnicas" "Arquitectura - Interface Tcl e Calculadora"
    }
    {
	Presentation slide33 picture estrutura_de_dados.gif \
	    "Tcnicas" "Arquitectura - Interface Tcl e Calculadora"
    }
    {
	Presentation slide34 text {
	    {"Cpia efectua rplica interna de dados seleccionados.\n" l left}
	    {"Alteraes so manipulaes da HashTable." l left}
	    {"Preservar as dependncias entre clulas." m left}
	    {"Redesenhar se for caso disso.\n" m left}
	    {"Paste Special mais complexo." l left}
	    {"Comparam-se tipos de clulas fonte e destino." m left}
	    {"Em funo da comparao copiam-se dados, frmulas e/ou formatos." m left}
	    {"Se pretendido, efectuam-se operaes aritmticas simples entre dados.\n" m left}
	} "Tarefas" "Edio, Insero e Alterao de Clulas"
    }
    {
	Presentation slide35 text {
	    {"Tamanho\n" l left}
	    {"Alinhamento\n" l left}
	    {"Tipo de letra (Font)\n" l left}
	    {"Formatos de dados\n" l left}
	    {"Fronteiras da clula (Borders)\n" l left}
	    {"Cores" l left}
	    {"Ainda s tons de cinzento..." m left}
	} "Tarefas" "Formatao de Clulas"
    }
    {
	set demo "Playing"
	set lst {
	    {
		ToggleDisplayBorders $activeSheet ;
		toggleCellBordersDisplay
		set currentRange ""
		set count 0
		set jump 0
		set last 0
		foreach fontname {0 1 2 3} {
		    foreach fontsize {0 1 2 3 4 5} {
			foreach fontitalic {0 1 2} {
			    foreach fontbold {0 1} {
				set x [expr [expr int([expr $count / 30])]+$jump]
				set y [expr [expr $count% 30] +1]
				CellSet $activeSheet $x $y "$fontname $fontsize $fontitalic $fontbold"
				SetFont $activeSheet $fontname $fontsize $fontitalic $fontbold $x $y 1
				set count [expr $count +2]
				if {$last < $x} {
				    set jump [expr $jump +2]
				    set last [expr $x +2] } 
			    }
			}
		    }
		}
		set temp 1
		CellSet $activeSheet 0 0 $temp
		for {set i 2} {$i<=3} {incr i} {
		    for {set j 2} {$i<=11} {incr i} {
			CellSet $activeSheet $i $j " "
		    }
		}
	    }
	    {
		SetBorders example  5 7 7 7  0 3
		SetBorders example  5 7 7 7  3 3
		SetBorders example  7 7 2 7  3 3 
		SetBorders example  7 5 7 7  3 3
		SetBorders example  7 3 7 7  6 3 
		SetAlignment example 2  0 11
		SetAlignment example 3  0 13
		SetFill example 50 6 11
		SetFill example 90 9 9
		SetFill example 20 6 13
		SetFill example 80 3 11
		SetFill example 90 3 13
		SetBorders example  7 7 7 3  9 5 
		SetBorders example  7 7 7 2  9 15 
		SetBorders example  7 7 3 7  9 3 
		SetBorders example  7 7 5 7  9 3 
		SetBorders example  1 7 7 7  3 15 
		SetBorders example  7 7 1 7  3 15 
		SetBorders example  7 1 7 7  3 15 
		SetBorders example  7 7 7 1  3 15 
		SetFill example 60 3 6
		SetFill example 60 10 2
		SetBorders example  7 5 7 7  6 1 
		SetBorders example  5 7 7 7  6 1 
		SetBorders example  7 7 7 5  6 1 
		SetBorders example  7 7 5 7  6 1 
		SetBorders example  7 3 7 7  0 10 
		SetBorders example  7 3 7 7  1 10 
		SetBorders example  7 3 7 7  2 10 
		SetBorders example  7 3 7 7  3 10
	    }
	    {
		set count 0
		set jump 0
		set last 0
		for {set i 0} {$i< 90} {incr i} {
		    set x [expr [expr int([expr $count / 30])]+$jump]
		    set y [expr [expr $count% 30] +1]
		    CellSet $activeSheet $x $y " "
		    set count [expr $count +2]
		    if {$last < $x} {
			set jump [expr $jump +2]
			set last [expr $x +2] } 
		}
	    }
	    {
		ToggleDisplayBorders $activeSheet ;
		toggleCellBordersDisplay
	    }
	}
	EvaluateScriptList .slideshow
	CellSet $activeSheet 1 1 " "
	set demo "Not Loaded"
    }
    {
	Presentation slide36 text {
	    {"ABS" m left}
	    {"ACOS" m left}
	    {"ASIN" m left}
	    {"ATAN" m left}
	    {"ATAN2" m left}
	    {"AVG" m left}
	    {"CELLPOINTER" m left}
	    {"CHAR" m left}
	    {"CODE" m left}
	    {"COS" m left}
	    {"COUNT" m left}
	    {"DAY" m left}
	    {"EXP" m left}
	    {"FALSE" m left}
	    {"HOUR" m left}
	    {"IF" m left}
	    {"INTF" m left}
	    {"ISERR" m left}
	    {"ISNA" m left}
	    {"ISNUMBER" m left}
	    {"ISSTRING" m left}
	    {"LENGTH" m left}
	    {"LN" m left}
	    {"LOG" m left}
	    {"LOWER" m left}
	    {"MAX" m left}
	    {"MIN" m left}
	    {"MINUTE" m left}
	    {"MOD" m left}
	    {"MONTH" m left}
	    {"PI" m left}
	    {"PROPER" m left}
	    {"RAND" m left}
	    {"ROUND" m left}
	    {"SECOND" m left}
	    {"SIN" m left}
	    {"SQRT" m left}
	    {"STRINGF" m left}
	    {"SUM" m left}
	    {"TAN" m left}
	    {"TIMEVALUE" m left}
	    {"TODAY" m left}
	    {"TRUE" m left}
	    {"UPPER" m left}
	    {"VALUE" m left}
	} "Tarefas" "Frmulas"
    }
    {
	Presentation slide37 text {
	    {"\tObjectivos planeados cumpridos..." l left}
	    {"\t...embora verso para Windows no tenha sido realizada.\n" m left}
	    {"\tProjecto nunca est concludo...evoluo  constante." l left}
	    {"\tOptimizar canvas." m left}
	    {"\tCores." m left}
	    {"\tEdio de grficos." m left}
	    {"\tIntegrao de imagens." m left}
	    {"\tSave/Record macros." m left}
	    {"\tVerso multiplataforma." m left}
	    {"\tPlugins." m left}
	    {"\tIdeias dos utilizadores..." m left}
	} "Concluses" "Resultados"
    }
    {
	Presentation slide38 text {
	    {"\tDesenvolvimento interno em espiral\n" l left}
	    {"\tPassagem para bazar" l left}
	    {"\tFase actual do Abacus." m left}
	    {"\tAcessos s pginas." m left}
	    {"\tMensagens utilizadores.\n" m left}
	    {"\tModelo bazar" l left}
	    {"\tRegisto de utilizadores." m left}
	    {"\tCriao de lista de correio." m left}
	} "Concluses" "Eficincia do Mtodo"
    }
}
