# $Id: sort.tcl,v 1.2 1998/10/25 22:27:30 cthulhu Exp $

proc GetColList {} {
    source "[xxl_library]/globalvars.tcl"

    set ret_list [list [format "Column %s" [ColName [lindex $currentRange 0]]]]
    set aux [lindex $currentRange 0]
    while {$aux < [lindex $currentRange 2]} {
	set aux [expr $aux+1]
	lappend ret_list [format "Column %s" [ColName $aux]]
    }
    return $ret_list
}

proc GetRowList {} {
    source "[xxl_library]/globalvars.tcl"

    set ret_list [list [format "Row %s" [expr [lindex $currentRange 1]+1]]]
    set aux [expr [lindex $currentRange 1]+1]
    while {$aux <= [lindex $currentRange 3]} {
	set aux [expr $aux+1]
	lappend ret_list [format "Row %s" $aux]
    }
    return $ret_list
}

proc SwapLBox {arg} {
    if {$arg == "rows"} {
	ChangeListboxMenu .sort.using.listbox [GetRowList]
    } else {
	ChangeListboxMenu .sort.using.listbox [GetColList]
    }
    .sort.using.listbox.f1.list selection set 0
}

proc SortFromToolbar {dir} {
    source "[xxl_library]/globalvars.tcl"

    SortCells $activeSheet \
	[lindex $currentRange 0] [lindex $currentRange 1] \
	[lindex $currentRange 2] [lindex $currentRange 3] \
	$dir 0 0
#    unhighlightCurrentRange [canvasFromSheet $activeSheet]
}

proc GoSort {dir row_col} {
    source "[xxl_library]/globalvars.tcl"

    SortCells $activeSheet \
	[lindex $currentRange 0] [lindex $currentRange 1] \
	[lindex $currentRange 2] [lindex $currentRange 3] \
	$dir $row_col [.sort.using.listbox.f1.list curselection]
    destroy .sort
#    unhighlightCurrentRange [canvasFromSheet $activeSheet]
}

proc SortCommand {} {
    source "[xxl_library]/globalvars.tcl"

    set globalState2 sortCells
    update

    if {$currentRange != ""} {
	
	toplevel .sort
	wm title .sort "Sort Options"
	
	frame .sort.sortby
	frame .sort.sortby.label
	label .sort.sortby.label.text -text "Sort:"
	pack .sort.sortby.label.text -side left
	
	frame .sort.sortby.options
	set RowOrCol 0
	radiobutton .sort.sortby.options.cols -variable RowOrCol \
	    -text Columns -value 1 -command {SwapLBox rows}
	radiobutton .sort.sortby.options.rows -variable RowOrCol \
	    -text Rows -value 0 -command {SwapLBox cols}
	.sort.sortby.options.rows select
	pack .sort.sortby.options.cols .sort.sortby.options.rows -side left
	pack .sort.sortby.label -side top -fill both -expand yes
	pack .sort.sortby.options -side left
	pack .sort.sortby -side top -fill both -expand yes
	
	frame .sort.using
	frame .sort.using.lbl
	label .sort.using.lbl.text -text "Using as sort key:"
	pack .sort.using.lbl.text -side left
	frame .sort.using.listbox
	createListboxMenu .sort.using.listbox [GetColList] lixo
	.sort.using.listbox.f1.list selection set 0
	pack .sort.using.lbl -side top -fill both -expand yes
	pack .sort.using.listbox -side top
	pack .sort.using -side top -fill both -expand yes
	
	frame .sort.order
	frame .sort.order.lbl
	label .sort.order.lbl.text -text "Sort direction:"
	pack .sort.order.lbl.text -side left
	frame .sort.order.options
	radiobutton .sort.order.options.asc -variable Dir -text Ascending \
	    -value 1
	radiobutton .sort.order.options.desc -variable Dir -text Descending \
	    -value 0
	.sort.order.options.asc select
	pack .sort.order.options.asc .sort.order.options.desc -side left
	pack .sort.order.lbl -side top -fill both -expand yes
	pack .sort.order.options -side left
	pack .sort.order -side top -fill both -expand yes
	
	frame .sort.endr
	button .sort.endr.ok -text Ok -command {GoSort $Dir $RowOrCol}
	button .sort.endr.abort -text Abort -command {destroy .sort}
	pack .sort.endr.ok .sort.endr.abort -fill x -expand yes -side bottom
	pack .sort.endr -side bottom -fill x -expand yes
	
	focus .sort
	grab .sort
	tkwait window .sort
    }
    set globalState2 normal
}

# $Log: sort.tcl,v $
# Revision 1.2  1998/10/25 22:27:30  cthulhu
# Sorting no longer unhighlights sorted range.
#
# Revision 1.1  1998/08/17 20:04:14  cthulhu
# Initial revision
#