/*
 * ratStdFolder.h --
 *
 *      Declarations of functions used in the Std folder and messages
 *
 * TkRat software and its included text is Copyright 1996,1997,1998
 * by Martin Forssn
 *
 * Postilion software and its included text and images
 * Copyright (C) 1998 Nic Bernstein
 *
 * The full text of the legal notices is contained in the files called
 * COPYING and COPYRIGHT.TkRat, included with this distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _RATPGP
#define _RATPGP

/* ratPGP.c */
extern char *RatPGPPhrase(Tcl_Interp *interp);
extern char *RatSenderPGPPhrase(Tcl_Interp *interp);
extern Tcl_TimerProc ClearPGPPass;
extern void RatPGPBodyCheck(Tcl_Interp *interp, MessageProcInfo *procInfo,
			    BodyInfo **bodyInfoPtrPtr);
extern Tcl_CmdProc RatPGPCmd;
extern char *RatPGPStrFind(char *haystack, long straws, char *needle,
			   int linestart);

/* ratPGPprog.c */
extern BODY *RatPGPEncrypt(Tcl_Interp *interp, ENVELOPE *env, BODY *body,
			   int sign);
extern BODY *RatPGPSign(Tcl_Interp *interp, BODY *body);
extern void RatPGPChecksig(Tcl_Interp *interp, MessageProcInfo *procInfo,
			   BodyInfo *bodyInfoPtr);
extern void RatPGPDecrypt(Tcl_Interp *interp, MessageProcInfo *procInfo,
			  BodyInfo **bodyInfoPtrPtr);
extern int RatPGPListKeys(Tcl_Interp *interp, char *keyring);
extern int RatPGPExtractKey(Tcl_Interp *interp, char *id, char *keyring);
extern int RatPGPAddKeys(Tcl_Interp *interp, char *keys, char *keyring);
extern void RatPGPHandleOld(Tcl_Interp *interp, BodyInfo *bodyInfoPtr,
			     char *text, char *start, char *end);

#endif /* _RATPGP */
