
/*
 * seq_print.c -- routines to print sequence information
 *
 * $Id$
 */

#include <h/mh.h>

#define empty(s) ((s) ? (s) : "")

/*
 * Print all the sequences in a folder
 */
void
seq_printall (struct msgs *mp)
{
    int i;

    for (i = 0; mp->msgattrs[i]; i++)
	printf ("%s%s: %s\n", mp->msgattrs[i],
	    is_seq_private (mp, i) ? " (private)" : "",
	    empty(seq_list(mp, mp->msgattrs[i])));
}


/*
 * Print a particular sequence in a folder
 */
void
seq_print (struct msgs *mp, char *seqname)
{
    int i;

    /* get the index of sequence */
    i = seq_getnum (mp, seqname);

    printf ("%s%s: %s\n", seqname,
	(i == -1) ? "" : is_seq_private(mp, i) ? " (private)" : "",
	empty(seq_list(mp, seqname)));
}
