;; mew-gnus.el
;;
;; Temporary solution to link Mew to Gnus.
;; This code will be obsolated because Mew supports USENET news soon.
;;
;; To use mew-gnus.el, put the following codes in your .emacs.
;;
;;   (add-hook
;;    'gnus-group-mode-hook
;;    (function
;;     (lambda ()
;;       (require 'mew-gnus)
;;       (define-key gnus-group-mode-map "a" 'mew-gnus-post-news))))
;;
;;   (add-hook
;;    'gnus-summary-mode-hook
;;    (function
;;     (lambda ()    
;;       (define-key gnus-summary-mode-map "a" 'mew-gnus-post-news)
;;       (define-key gnus-summary-mode-map "r" 'mew-gnus-reply)
;;       (define-key gnus-summary-mode-map "R" 'mew-gnus-reply-with-citation)
;;       (define-key gnus-summary-mode-map "f" 'mew-gnus-mail-forward))))
;;
;;   (setq gnus-default-article-saver 'gnus-summary-save-in-mew)
;;

(eval-when-compile 
  (require 'gnus)
  (if (not (or (string-match "^GNUS [34]" gnus-version)
	       (string-match "^Gnus v5.0" gnus-version)
	       (string-match "^5.[0-3]" gnus-version-number)))
      (require 'gnus-sum)))

(require 'mew)

(defvar mew-prog-imstore "imstore")
(defvar mew-prog-imstore-arg "--dst=%s")
;(defvar mew-prog-imstore "/usr/local/lib/mh/rcvstore")
;(defvar mew-prog-imstore-arg "%s")

(defvar mew-gnus-save-fixed-folder nil
  "*If specified, always use it as a candidate to save article.")

(defvar mew-gnus-save-preserve-dot t
  "*If nil, use hierarchical directory to save article.")

(defun mew-gnus-newsgroup-name ()
  (if mew-gnus-save-preserve-dot
      gnus-newsgroup-name
    (gnus-newsgroup-directory-form gnus-newsgroup-name)))

(defun gnus-summary-save-in-mew (&optional folder)
  "Save this article to MH folder (using `rcvstore' in MH library).
Optional argument FOLDER specifies folder name."
  (interactive)
  (let ((gnus-show-mime nil))
    (gnus-summary-select-article t t))  ;; force to display all headers
  (gnus-eval-in-buffer-window gnus-article-buffer
    (save-restriction
      (widen)
      (or mew-folder-alist
	  (setq mew-folder-list (mew-folder-make-list nil)
		mew-folder-alist (mew-folder-make-alist mew-folder-list)))
      (let ((folder
	     (or folder
		 (mew-input-folder
		  (or mew-gnus-save-fixed-folder
		      (car (mew-refile-guess-by-alist))
		      (concat "+" (mew-gnus-newsgroup-name))))))
	    (errbuf (get-buffer-create " *GNUS rcvstore*")))
	(if (not (equal (aref folder 0) ?+))
	    (message (format 
		      "First letter of '%s' must be '+'."
		      folder))
	  (if (mew-folder-check folder)
	      (unwind-protect
		  (mew-piolet
		   mew-cs-infile mew-cs-outfile
		   (call-process-region (point-min) (point-max)
					mew-prog-imstore nil errbuf nil
					(format mew-prog-imstore-arg folder)))
		(set-buffer errbuf)
		(if (zerop (buffer-size))
		    (message "Article saved in folder: %s" folder)
		  (message "%s" (buffer-string)))
		(kill-buffer errbuf))))))))

(defun mew-gnus-post-news ()
  "Post a news using mew."
  (interactive)
  (or mew-temp-dir
      (save-excursion
	(mew-set-environment)))
  (let ((file (mew-folder-new-message mew-draft-folder)))
    (if (null mew-mail-path) (mew-init))
    (mew-current-set 'window (current-window-configuration))
    (delete-other-windows)
    (switch-to-buffer (find-file-noselect file))
    (mew-draft-rename file)
    (mew-draft-header nil nil 'no nil "")
    (mew-draft-mode) ;; for hilight
    (goto-char (point-min))
    (search-forward "Newsgroups: ")))

(defun mew-gnus-reply (&optional yank)
  "Reply or followup to GNUS article using mew.
Optional argument YANK means yank original article."
  (interactive)
  (or mew-temp-dir
      (save-excursion
	(mew-set-environment)))
  (let ((file (mew-folder-new-message mew-draft-folder))
	from cc subject date to reply-to newsgroups in-reply-to references
	distribution)
    (if (null mew-mail-path) (mew-init))
    (mew-current-set 'window (current-window-configuration))
    (delete-other-windows)
    (gnus-summary-display-article (gnus-summary-article-number) t) ;; redisplay
    (pop-to-buffer gnus-article-buffer)
    (goto-char (point-max))
    (push-mark (point) t t)
    (goto-char (point-min))
    (search-forward "\n\n" nil t)
    (let ((split-window-keep-point t))
      (split-window-vertically))
    (setq from (mew-addrstr-parse-address-list (gnus-fetch-field "From"))
	  subject (let ((subject (gnus-fetch-field "Subject")))
		    (if (and subject
			     (not (string-match "^[Rr][Ee]:.+$" subject)))
			(concat "Re: " subject) subject))
	  reply-to (gnus-fetch-field "Reply-to")
	  to (or reply-to from)
	  cc (gnus-fetch-field "Cc")
	  newsgroups (or (gnus-fetch-field "Followup-To")
			 (gnus-fetch-field "Newsgroups"))
	  date (gnus-fetch-field "Date")
	  in-reply-to (mew-header-get-value "Date:")
	  references (mew-header-get-value "Message-ID:")
	  distribution (gnus-fetch-field "Distribution"))
    (switch-to-buffer-other-window (find-file-noselect file))
    (mew-draft-rename file)
    (mew-draft-header subject nil to cc newsgroups in-reply-to references)
    (mew-draft-mode) ;; for hilight
    (if (stringp distribution)
	(save-excursion
	  (goto-char (point-min))
	  (search-forward "Newsgroups:")
	  (forward-line 1)
	  (insert (concat "Distribution: " distribution "\n"))))
    (make-variable-buffer-local 'mew-message-citation-buffer) 
    (setq mew-message-citation-buffer gnus-article-buffer))
  (if yank
      (progn
	(goto-char (point-max))
	(mew-draft-cite))))

(defun mew-gnus-reply-with-citation ()
  "Reply or followup to GNUS article using mew.
Original article is yanked automatically."
  (interactive)
  (mew-gnus-reply t))

(defun mew-gnus-mail-forward (&optional buffer)
  "Forward the current message to another user using mew."
  (interactive)
  (or mew-temp-dir
      (save-excursion
	(mew-set-environment)))
  (mew-current-set 'window (current-window-configuration))
  (pop-to-buffer (or (and (boundp 'gnus-original-article-buffer)
			  gnus-original-article-buffer)
		     gnus-article-buffer))
  (let* ((subject (concat "[" gnus-newsgroup-name "] "
			  (or (gnus-fetch-field "subject") "")))
	 (file (mew-folder-new-message mew-draft-folder))
	 (mimefolder (mew-draft-to-mime file))
         (mimedir (mew-expand-folder mimefolder)))
    (if (null (file-directory-p mimedir))
        (mew-make-directory mimedir)
      (if (null (mew-directory-empty-p mimedir))
          (if (y-or-n-p (format "Mime folder %s is not empty. Delete it? "
				mimefolder))
              (progn
                (call-process "rm" nil nil nil "-rf" mimedir)
                (mew-make-directory mimedir)))))
    (unwind-protect
	(progn
	  (write-region (point-min) (point-max)
			(mew-folder-new-message mimefolder))
	  (let ((split-window-keep-point t))
	    (split-window-vertically))
	  (switch-to-buffer-other-window (find-file-noselect file))
	  (mew-draft-rename file)
	  (mew-draft-header subject 'nl)
	  (mew-draft-mode)
	  (setq mew-encode-syntax
		(mew-encode-syntax-initial-multi
		 (file-name-nondirectory mimedir) 1))
	  (save-excursion
	    (mew-draft-prepare-attachments)))
      (save-buffer))) ;; to make sure no to use this draft again
  (message "Draft is prepared"))

(provide 'mew-gnus)
;;; mew-gnus.el ends here
