# Copyright (C) 1993-1998 Ken'ichi Fukamachi
#          All rights reserved. 
#               1993-1996 fukachan@phys.titech.ac.jp
#               1996-1998 fukachan@sapporo.iij.ad.jp
# 
# FML is free software; you can redistribute it and/or modify
# it under the terms of GNU General Public License.
# See the file COPYING for more details.
#
# $Id: fmlserv-config.ph,v 1.0 1998/09/06 05:43:11 fukachan Exp $
#

# ### Section: "fmlserv" Mailing List Configurations ###
#
# The directory above each mailing list.
$MAIL_LIST_DIR     = "_ML_DIR_";

# fmlserv's HOME directory. "fmlserv" is just one of mailing lists.
$FMLSERV_DIR       = "$MAIL_LIST_DIR/fmlserv";

# log file
$FMLSERV_LOGFILE   = "$FMLSERV_DIR/log";

# In default, "lists" command is NOT AVAILABLE FOR SECURITY.
# If you permit "lists" command in fmlserv, you set 1.
$FMLSERV_PERMIT_LISTS_COMMAND = 0;
$FMLSERV_PERMIT_WHICH_COMMAND = 0;

##################################################################
# global debug option. if non-nil, debug mode.
# In debug mode, NOT do distribution
$debug                         = 0;

# for further extension: FML 2.1 DOES NOT use this 
# except for files (e.g. help, welcome, ...) created in "makefml newml"
$LANGUAGE                      = "Japanese";

# ## Sub Section: DNS ##
# DNS setting s automatically checked by makefml but check them, please
#
#    DOMAINNAME the domain name              e.g. fml.org
#    FQDN       Fully Qualified Domain Name  e.g. beth.fml.org
#
$DOMAINNAME                    = "_DOMAIN_";
$FQDN                          = "_FQDN_";

#####################################################################
# ### Section: Mailing List Policy (for Post, Commands), Maintainer ###
#
# $MAIL_LIST is THE ADDRESS FOR POST.
# $PERMIT_POST_FROM is "anyone", "members_only" or "moderator", 
# which permit post from who? If not-member posts is rejected,
# THE FUNCTION $REJECT_POST_HANDLER is applied.
# $REJECT_POST_HANDLER is "reject", "auto_regist" or "ignore"
#
# **ATTENTION**: "reject" implies just "NOT REGISTERED IN $MEMBER_LIST".
#    See "Section: Security" for positive reject against e.g. spammers.
#
$MAIL_LIST                     = "fmlserv\@$DOMAINNAME";

# ## Sub Section: Maintainer ##
# $MAINTAINER != $MAIL_LIST IS REQUIRED AGAINST MAIL LOOP
$MAINTAINER                    = "fmlserv-admin\@$DOMAINNAME";
# $MAINTAINER_SIGNATURE        = "";

#####################################################################
# ### Section: Directory  ###
# We use fully pathed directory name => $FP_SPOOL_DIR(= $DIR/$SPOOL_DIR)
# and relative path $SPOOL_DIR (e.g. spool) 
# article spool directory
$SPOOL_DIR                     = "spool";

$TMP_DIR                       = "tmp"; # tmp, after chdir, under DIR


$VAR_DIR                       = "var"; # LOG is /var/log (4.4BSD style)

$VARLOG_DIR                    = "var/log";
$VARRUN_DIR                    = "var/run";
$VARDB_DIR                     = "var/db";


#####################################################################
# ### Section: SMTP and Delivery ###
#
# [IPC] to speak to Sendmail via Simple Mail Transfer Protocol($PORT/tcp).
# $HOST is an arbitrary host(if you can access it) which runs MTA
# (e.g. sendmail).  If the Mailing List Server machine is week, 
# you can use the sendmail of another powerful host(host).
#
$HOST                          = "localhost";
$PORT                          = 25;

# IF $NOT_TRACE_SMTP IS 1 (default 0), we log the SMTP session to $SMTP_LOG
# IF $TRACE_SMTP_DELAY IS 1, we logs the delay of response between SMTP server.
$SMTP_LOG                      = "$VARLOG_DIR/_smtplog";
# $NOT_TRACE_SMTP              = 0;
# $TRACE_SMTP_DELAY            = "";

# IF YOU USE PLURAL SMTP SERVER FOR DELIVERY, Please set the number to
# $MCI_SMTP_HOSTS and define them to @HOSTS as the array components.
# $MCI_SMTP_HOSTS              = "";

# ## Relay server ##
# each user relay is defined in delivery list as "m=relay-host".
# If $DEFAULT_RELAY_SERVER is set, we apply it for all members.
# $DEFAULT_RELAY_SERVER        = "";

# CF (by motonori@wide.ad.jp) base relay control if $RELEY_HACK is on. 
# with %RELAY_GW, %RELAY_NGW, %RELAY_NGW_DOM (set in librelayhack.pl)
# $CF_DEF is CF's configuration files; 
# **ATTENTION**; we do not use sendmail.cf but CF's configuration.
# $RELAY_HACK                  = "";
# $CF_DEF                      = "";

#####################################################################
# ### Section: MISC ###

# ## Sub Section: Preamble and Trailer for Mail Body ##
# If you always append some message in the mail body, you can use these.
# e.g. mail body becomes
#
#    $PREAMBLE_MAILBODY
#    original body
#    $TRAILER_MAILBODY
#
# $PREAMBLE_MAILBODY           = "";
# $TRAILER_MAILBODY            = "";

# ## Sub Section: Reply Configurations ##
# In the last of e.g. "command status report", we add 
# "$GOOD_BYE_PHRASE $FACE_MARK" :-) in the last of the reply. 
# So the standard form is
#
#    message
#    FYI message generated by the function $PROC_GEN_INFO.
#    $GOOD_BYE_PHRASE $FACE_MARK
#
$GOOD_BYE_PHRASE               = "--$MAIL_LIST, Be Seeing You!";
# $FACE_MARK                   = "";
$PROC_GEN_INFO                 = "GenInfo";

# ## Sub Section: Lock Algorithm ##
# use flock for lock algorithm if $USE_FLOCK is on.
# see flock(2), alarm(3). If not, we rename(2) base lock.
# The timeout of rename(2) lock is rand(3) *  $MAX_TIMEOUT secs.
$USE_FLOCK                     = 1;
$MAX_TIMEOUT                   = 200;

# ## Sub Section: misc ##
# Not spooling (default is "spooling")
# $NOT_USE_SPOOL               = "";

# "$CFVersion < 2" equals "$COMPAT_FML15 = 1;"
# $COMPAT_FML15                = 0;

# newsyslog library maximum number. default is 4. So
# log.3 -> log.4, log.2 -> log.3, log.1 -> log.2, log.0 -> log.1, log -> log.0
$NEWSYSLOG_MAX                 = 4;


#####################################################################
# ### Section: Architecture Dependence ###
# cpu-type manufacturer operating-system by GNU config.guess ("makefml")
$CPU_TYPE_MANUFACTURER_OS      = "i386-unknown-netbsd1.2";

$STRUCT_SOCKADDR               = "_STRUCT_SOCKADDR_"; # struct sockaddr


# flock system call; please see "/usr/include/sys/file.h"
$LOCK_SH                       = 1;
$LOCK_EX                       = 2;
$LOCK_NB                       = 4;
$LOCK_UN                       = 8;


######################################################################
# ### Section: LOCAL CONFIG ###


1;
