static char rcsid[] = "@(#)$Id: syscall.c,v 1.1.2.4 1999/10/10 15:56:58 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.1.2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *
 * Some code based on ../src/syscall.c. It have following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "headers.h"
#include "melib.h"
#include "s_elm.h"

#include <errno.h>

int set_child_signals(options)
     int options;
{
    /*
     * Program to exec may or may not be able to handle
     * interrupt, quit, hangup and stop signals.
     */
    if (options&SY_ENAB_SIGINT)
	options |= SY_ENAB_SIGHUP;
    (void) signal(SIGHUP,  (options&SY_ENAB_SIGHUP) ? SIG_DFL : SIG_IGN);
    (void) signal(SIGINT,  (options&SY_ENAB_SIGINT) ? SIG_DFL : SIG_IGN);
    (void) signal(SIGQUIT, (options&SY_ENAB_SIGINT) ? SIG_DFL : SIG_IGN);
#ifdef SIGTSTP
    (void) signal(SIGTSTP, (options&SY_ENAB_SIGHUP) ? SIG_DFL : SIG_IGN);
    (void) signal(SIGCONT, (options&SY_ENAB_SIGHUP) ? SIG_DFL : SIG_IGN);
#endif
    return 0;
}

int set_child_env(options)
     int options;
{
    /* Optionally override the MM_CHARSET environment variable. */
    if (options&SY_ENV_METAMAIL) {
	static char mm[] = "MM_CHARSET=";
	int size = sizeof(mm) + strlen(display_charset);
	
	/* \0 character is included in size returned by sizeof */
	char *p = malloc(size);
	if (p) {
	    elm_sfprintf(p, size,
			 FRM("%s%s"), mm , display_charset );
	    putenv(p);
	}
    }
    
    /* Optionally override the SHELL environment variable. */
    if (options&SY_ENV_SHELL) {
	static char sheq[] = "SHELL=";
	char * sh = ((options & SY_USER_SHELL) ? shell : "/bin/sh");
	int size = sizeof(sheq) + strlen(sh);

	char *p = malloc(size);
	if (p) {
	    elm_sfprintf(p, size,
			 FRM("%s%s"), sheq, sh);
	    putenv(p);
	}
    }
    return 0;
}

#ifdef BACKGROUD_PROCESSES       /* We assume POSIX in here */

static struct process_list {
    FILE * fd;
    char * message;
    struct run_state state_information;
    end_handler *handler;
    struct process_list * next;
} * my_processes = NULL;

static void got_sigchld P_((int sig));
static void got_sigchld (sig) 
     int sig;
{
    handle_sigchld = 1;
}

void sigchld_handler() {
    
    dprint(2, (debugfile, "sigchld_handler --> ENTER\n"));
    
    do {
	struct process_list *tmp = my_processes, *prev = NULL;
	handle_sigchld = 0;
	
	while (tmp) {
	    struct process_list * this = tmp;
	    int exit_code;
	    int ret = run_already_done(&(tmp->state_information),&exit_code);
	    
	    if (ret != 0) {
		
		tmp->handler(tmp->fd,tmp->message,&(tmp->state_information),
			     ret,exit_code);
		
		if (prev)
		    prev -> next = tmp -> next;
		else
		    my_processes = tmp -> next;
		
		dprint(2, (debugfile, "sigchld_handler: deleting %d from list: %s\n",
			   tmp->state_information.pid, tmp->message));
		
		free(tmp->message);
		tmp = tmp -> next;
		free(this);
		continue;
	    }
	    
	    prev = tmp;
	    tmp  = tmp -> next;
	}
	
    } while (handle_sigchld);
    
    dprint(2, (debugfile, "sigchld_handler --> LEAVE\n"));
}

void init_backgroud_handling () {
    /* We use POSIX sigaction here,
     * so that we not depend different semantic
     * between SYSV and BSD signal(SIGCHLD, ...)
     */
    
    struct sigaction new_child;
    
    new_child.sa_flags    = 0;
#ifdef SA_INTERRUPT
    new_child.sa_flags |= SA_INTERRUPT;           /* SunOS? */
#endif
    new_child.sa_handler = got_sigchld;
    sigemptyset(& (new_child.sa_mask));
    
    if (-1 == sigaction(SIGCHLD,&new_child,NULL)) {
	int err = errno;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSigaction,"sigaction: %s"),
		  error_description(err));
	exit (1);
    }
}

int maybe_background (rs,exit_code,fd,title,func) 
     struct run_state *rs;
     int *exit_code;
     FILE *fd;
     char *title; 
     end_handler *func; 
{
    int ret;
    struct process_list *listptr;
    if (!title)
	title = "NO NAME";
    
    if (rs->raw == ON && RawState() == OFF) {
	
	ret = wait_end (rs,exit_code);
	if (ret != 0)
	    return ret;
    }
    
    listptr = safe_malloc(sizeof (struct process_list));
    rs -> listptr = listptr;
    listptr -> fd      = fd;
    listptr -> message = safe_strdup(title);
    listptr -> state_information = *rs;
    listptr -> handler = func;
    listptr -> next = my_processes;
    my_processes = listptr;
    return 0;
} 
#endif

static void raw_exit P_((struct run_state *rs));
static void raw_exit(rs)
     struct run_state *rs;
{
    if (rs->raw == ON && RawState() == OFF) {
	dprint(4, (debugfile, "raw_exit: setting RAW on\n"));
	Raw(ON|NO_TITE);
    }  else {
	dprint(4, (debugfile, "raw_exit: no state change\n"));
    }
}

static void print_status P_((struct run_state *rs,int sig,int exit_code));
static void print_status(rs,sig,exit_code) 
     struct run_state *rs;
     int sig, exit_code;
{
    if (rs->raw == ON && ( SY_CLRWAIT & rs->options )) {
    redraw:
	if (sig) 
	    PutLineX(elm_LINES,0,
		     CATGETS(elm_msg_cat, ElmSet, 
			     ElmTerminatedWithSignal,
			     "Terminated with signal %d. Press any key to continue: "),
		     sig);
	else if (exit_code)
	    PutLineX(elm_LINES,0,
		     CATGETS(elm_msg_cat, ElmSet, 
			     ElmExitedWithStatus,
			     "Exited with status %d. Press any key to continue: "),
		     exit_code);
	else
	    PutLineX(elm_LINES,0,
		     CATGETS(elm_msg_cat, ElmSet, 
			     ElmDoneCont,
			     "Done. Press any key to continue: "));
	if (ReadCh(REDRAW_MARK) == REDRAW_MARK) 
	    goto redraw;
    }
}

int run_already_done (rs,exit_code)
     struct run_state *rs;
     int *exit_code;
{
    S__ status;
    
#ifdef HASWAITPID
    int w;
    /* waitpid is on POSIX */
    
    *exit_code = -1;
    
    w = waitpid(rs->pid,&status,WNOHANG);
    
    if (w == 0) {
	dprint(2, (debugfile, "run_already_done=%d (w=%d)\n",0,w));
	return 0;
    }

    if (w == -1) {
	rs->save_errno = errno;
	dprint(2, (debugfile, "run_already_done: errno=%d\n", rs->save_errno));
	
	if (rs->save_errno == EINTR) {
	    dprint(2, (debugfile, "run_already_done=%d (w=%d) [EINTR]\n",0,w));
	    return 0;
	}
    }
    
    raw_exit(rs);

    if (w == rs->pid) {
	int sig = convert_status(status,exit_code);
	
	dprint(2, (debugfile, "run_already_done: exit_code=%d, sig=%d\n", 
		   *exit_code,sig));
	
	print_status(rs,sig,*exit_code) ;
	
	if (sig) {
	    dprint(2, (debugfile, "run_already_done=%d\n",-sig));
	    return -sig;
	}
    }
    dprint(2, (debugfile, "run_already_done=%d\n",w != -1));
    return w != -1;
#else
    dprint(2, (debugfile, "run_already_done=%d (no HASWAITPID)\n",0));
    return 0;      
#endif
}

int wait_end  (rs,exit_code)
     struct run_state *rs;
     int *exit_code;
{
    int w;
    S__ status;
    
    *exit_code = -1;
    
    while ((w = my_wait(rs->pid,&status)) != rs->pid)
	if (w == -1 && errno != EINTR)
	    break;
    
    if (w == -1) {
	rs->save_errno = errno;
	dprint(2, (debugfile, "wait_end: errno=%d\n", rs->save_errno));    
    }
    
    raw_exit(rs);
    
    if (w == rs->pid) {
	int sig = convert_status(status,exit_code);
	
	dprint(2, (debugfile, "wait_end: exit_code=%d, sig=%d\n", 
		   *exit_code,sig));
	
	print_status(rs,sig,*exit_code);
	
	if (sig) {
	    dprint(2, (debugfile, "wait_end=%d\n",-sig));
	    return -sig;
	}
    }
      
    dprint(2, (debugfile, "wait_end=%d\n",w != -1));
    return w != -1;
}

char ** join_argv(argv1,argv2)
     char * argv1[];
     char * argv2[];
{
    int count1;
    int count2;
    char ** res;
    int i;
    for (count1 = 0; argv1[count1]; count1++);
    for (count2 = 0; argv2[count2]; count2++);
    
    res = safe_malloc((count1 + count2 + 1)* sizeof (char *));
    
    for (i = 0; i < count1; i++)
	res[i] = argv1[i];
    for (i = 0; i < count2; i++)
	res[i + count1] = argv2[i];
    res[count1 + count2] = NULL;
    
    return res;
}

int start_run(rs, options, argv, infd, outfd)
     struct run_state *rs;
     int options;
     char * argv[];
     int infd, outfd;
{
    int count;
    int pfd[2], stat;
    static int fd = -1;
    int notty = (options & SY_NOTTY) != 0;
    
    dprint(2, (debugfile, "start_run: [0] %s\n", argv[0]));
    for (count = 1; argv[count]; count++) {
	dprint(2, (debugfile, "           [%d] %s\n", count,argv[count]));
    }
    dprint(2, (debugfile, "    infd=%d, outfd=%d\n",infd,outfd));
    
    if (fd == -1)
	fd = open("/dev/null",O_RDONLY);
    dprint(2, (debugfile, "    fd=%d \n", fd));
    
    /* flush any pending output */
    fflush(stdout);
    rs->save_errno = 0;
    rs->raw     = RawState();
    rs->options = options;
#ifdef BACKGROUD_PROCESSES      
    rs->listptr = NULL; 
#endif
    
    if (!notty) {
	MoveCursor(elm_LINES,0);
	CleartoEOLN();
	fflush(stdout);
	if (rs->raw == ON) {
	    if (options & SY_CLRWAIT) {
		ClearScreen();
	    }
	    dprint(4, (debugfile, "start_run: setting RAW off\n"));
	    Raw(OFF|NO_TITE);
	}
	if (options & SY_CLRWAIT) {
	    printf("Executing: %s ...\n\n",argv[0]);
	}
    }
    
    if (pipe(pfd) == -1) {
	rs->save_errno = errno;
	
	raw_exit(rs);
	return 0;
    }
    fcntl(pfd[0], F_SETFD, 1);
    fcntl(pfd[1], F_SETFD, 1);
    
    rs->pid = fork();
    
    if (rs->pid == -1) {
	rs->save_errno = errno;
	
	raw_exit(rs);
	return 0;
    }
    else if (rs->pid == 0) {
	close(pfd[0]);
	/*
	 * Set group and user back to their original values.
	 * Note that group must be set first.
	 */
	setgid(groupid);
	setuid(userid);
	
	set_child_signals(options);
	
	set_child_env(options);
	
	if (options & SY_RUN_STATE_ENV) {
	    int i;
	    for (i = 0; rs->ext_env[i]; i++) {
		putenv(rs->ext_env[i]);
	    }
	}

	if (options & SY_RUN_STATE_INIT) {
	    rs->ext_init(rs);
	}

	if (notty) {
	    if (infd != 0  && -1 == dup2(fd,0) ||
		outfd != 1 && -1 == dup2(fd,1) ||
		outfd != 2 && -1 == dup2(fd,2)) { 
		write(pfd[1],(void *)&errno,sizeof errno); _exit(127); 
	    }

#ifdef SIGTTSTP
	    signal(SIGTTIN, SIG_IGN); 
	    signal(SIGTTOU, SIG_IGN);
	    signal(SIGTSTP, SIG_IGN);
#endif
	}
	
	if (infd >= 0) {
	    if (infd != 0  && -1 == dup2(infd,0)) {
		write(pfd[1],(void *)&errno,sizeof errno); _exit(127); 
	    }
	}
	if (outfd >= 0) {
	    if (outfd != 1  && -1 == dup2(outfd,1)) {
		write(pfd[1],(void *)&errno,sizeof errno); _exit(127); 
	    }
	}
	execvp(argv[0],argv);
	write(pfd[1],(void *)&errno,sizeof errno); _exit(127); 
    }
    else {
	int code, rd;
	close(pfd[1]);
	
	dprint(4, (debugfile, "start_run: child pid=%d\n", rs->pid));
	rd = read(pfd[0],(void *)&code, sizeof code);
	close(pfd[0]);
	
	if (rd > 0) {
	    int exitcode;
	    
	    wait_end(rs,&exitcode);
	    if (rd == sizeof code)
		rs->save_errno = code;
	    else
		rs->save_errno = 0;
	    return 0;
	}
	return 1;
    }
    raw_exit(rs);
    return 0;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
