/*								-*- C++ -*-
 * $Id: DAT_typetree.h,v 1.2 1996-11-19 13:29:58+01 mho Exp $
 *
 * Purpose: type tree (type keys defined in common.h)
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef TypeTree_h
#define TypeTree_h

#ifdef __GNUG__
#pragma interface
#endif

void wxInitStandardTypes(void);

class wxTypeDef : public wxObject {
DECLARE_DYNAMIC_CLASS(wxTypeDef)
public:
    inline wxTypeDef(void)   { name = NULL; }
    inline ~wxTypeDef(void)  {}
#if WXDEBUG
    virtual void Dump(ostream& str);
#endif
private:
    friend Bool wxSubType(WXTYPE type1, WXTYPE type2);
    friend char *wxGetTypeName(WXTYPE type);
    friend class wxTypeTree;

    char    *name;
    WXTYPE  type;
    WXTYPE  parent;
};

class wxTypeTree : public wxList {
DECLARE_DYNAMIC_CLASS(wxTypeTree)
public:
    wxTypeTree(void);
    ~wxTypeTree(void);

    void  AddType(WXTYPE t, WXTYPE parent, char *name);
    char  *GetName(WXTYPE t) { return wxGetTypeName(t); }
};

#endif // TypeTree_h
