/*								-*- C++ -*-
 * $Id: WIN_textwindow.cpp,v 1.2 1997-02-28 16:04:14+01 mho Exp $
 *
 * Purpose: text window panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_textwindow.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxTextWindow
#include "wx.h"
//#define  Uses_AsciiTextWidgetPrivate
#define  Uses_AsciiTextWidget
#define  Uses_EnforcerWidget
#define  Uses_ScrollWinWidget
#include <widgets.h>

#include <unistd.h>		// for access
#include <sys/types.h>		// for stat/fileinfo
#include <sys/stat.h>

//-----------------------------------------------------------------------------
// create and destroy textWindow
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxTextWindow, wxMultiText)

wxTextWindow::wxTextWindow(void) : wxMultiText(), streambuf()
{
    __type = wxTYPE_TEXT_WINDOW;

    if( allocate() )
	setp(base(),ebuf());
 
    modified = FALSE;
}

wxTextWindow::wxTextWindow(wxWindow *panel, int x, int y, int width, int height,
			   long style, Constdata char *name) : wxMultiText(), streambuf()
{
    __type = wxTYPE_TEXT_WINDOW;

    if( allocate() )
	setp(base(),ebuf());

    modified = FALSE;
    Create(panel, x, y, width, height, style, name);
}

Bool wxTextWindow::Create(wxWindow *panel, int x, int y, int width, int height,
			 long style, Constdata char *name)
{
    if (!panel || !panel->IsKindOf(CLASSINFO(wxPanel)))
	wxFatalError("parent has to be a wxFrame, wxPanel, or any subtype", "wxTextWindow");
    ChainToPanel((wxPanel*)panel, style, name);

    XFontStruct *xfont = font.GetInternalFont();

    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNalignment,          XfwfTop,
	 XtNbackground,         bg.GetPixel(&cmap),
	 XtNforeground,         label_fg.GetPixel(&cmap),
	 XtNfont,               label_font.GetInternalFont(),
	 XtNhighlightThickness, 2,
	 XtNlabelOffset,        2,
	 XtNtraversalKeys,      XfwfTraverseKeyTab,
	 NULL);
    // create viewport
    PWidget() = XtVaCreateManagedWidget
	(name, xfwfScrolledWindowWidgetClass, FWidget(),
	 XtNbackground,      bg.GetPixel(&cmap),
	 XtNscrollingPolicy, XfwfUserScrolling,
	 XtNtraversalKeys,   XfwfTraverseKeyTab,
	 XtNvIncrement,      xfont->ascent+xfont->descent,
	 XtNhIncrement,      xfont->max_bounds.width,
	 NULL);
    // create textWindow widget
    HWidget() = XtVaCreateManagedWidget
	(name, asciiTextWidgetClass, PWidget(),
	 XtNbackground,       bg.GetPixel(&cmap),
	 XtNforeground,       fg.GetPixel(&cmap),
	 XtNfont,             font.GetInternalFont(),
	 XtNtopMargin,        2,
	 XtNrightMargin,      2,
	 XtNborderWidth,      0,
	 XtNtype,             XawAsciiFile,
// 	 XtNscrollVertical,   XawtextScrollNever,
// 	 XtNscrollHorizontal, XawtextScrollNever,
// 	 XtNresize,           XawtextResizeNever,
	 XtNeditType,         (style & wxREADONLY ? XawtextRead : XawtextEdit),
	 NULL);
    // callback
    XtAddCallback(XawTextGetSource(HWidget()), XtNcallback,
		  wxTextWindow::EventCallback, (XtPointer)this);

    ((wxPanel*)panel)->PositionItem(this, x, y,
				    (width  > -1 ? width  : wxTEXT_WINDOW_WIDTH),
				    (height > -1 ? height : wxTEXT_WINDOW_HEIGHT));
    AddEventHandlers();
    return TRUE;
}

//-----------------------------------------------------------------------------
// methods to allow program to modify text
//-----------------------------------------------------------------------------

void wxTextWindow::Clear(void)
{
    XtVaSetValues(HWidget(), XtNstring, NULL, NULL);
}

/* Martin Sperl
char *wxTextWindow::GetContents(void)
{
    char *value=NULL;
    
    off_t i;
    int c;
    // get a temporary filename
    char *filename=::wxGetTempFileName("TextOut");
    // write the file to a temprary file
    SaveFile(filename);
    // get size of file
    struct stat fileinfo;
    stat(filename,&fileinfo);
    off_t size=fileinfo.st_size;
    // allocate buffer (more just in case...);
    value= new char[size+10];
    // clean buffer
    for (i=0;i<size+10;i++) { value[i]=0; }
    // read from file
    FILE* file=fopen(filename,"r");
    // cannot open file
    if (file==NULL) { delete value; return NULL; }
    // fill buffer
    for (i=0;i<size;i++)
	{
	    c=(char)fgetc(file);
	    if (c!=EOF)
		{
		    // write to Buffer
		    value[i]=(char)c;
		}
	    else
		{
		    // write End of text
		    value[i]=0;
		    break;
		}
	}
    // write End of text again, just to be sure...
    value[i]=0;
    // close file
    fclose(file);
    // delete file
    ::wxRemoveFile(filename);
    // delete filename
    delete filename;
    // return buffer
    return value;
}
*/

char *wxTextWindow::GetContents(void)
{
    static XawTextBlock text_block;
    Widget src = XawTextGetSource(HWidget());
    text_block.firstPos = 0;
    text_block.format = FMT8BIT;
    int maxlength = 1000000;
    XawTextSourceRead(src, 0, &text_block, maxlength);
    return text_block.ptr;
}

long wxTextWindow::GetInsertionPoint(void)
{
    return long(XawTextGetInsertionPoint(HWidget()));
    XawTextPosition beg, end;
    XawTextGetSelectionPos(HWidget(),&beg,&end);
    cout<<"beg = "<<beg<<" ; end = "<<end<<endl;
    
}

long wxTextWindow::GetLastPosition(void)
{
    return LastPosition();
}

int wxTextWindow::GetLineLength(long WXUNUSED(lineNo))
{
    return 0;
}

int wxTextWindow::GetLineText(long WXUNUSED(lineNo), char *WXUNUSED(buf))
{
    return 0;
}

int wxTextWindow::GetNumberOfLines(void)
{
    return 0;
}

Bool wxTextWindow::LoadFile(char *file)
{
    Bool readable = FALSE, writable = FALSE;

    if (file) {
	readable = (Bool)(access(file, R_OK) == 0);
	writable = (Bool)(access(file, W_OK) == 0);
    }

    XtVaSetValues
	(HWidget(),
	 XtNeditType, (((style & wxREADONLY) || !writable) && readable) ? XawtextRead
									: XawtextEdit,
	 XtNstring,   (readable ? file : NULL),
	 NULL);
    modified = FALSE;

    // set scrollbars
    AdjustScrollbars();

    return readable;
}

void wxTextWindow::PositionToXY(long WXUNUSED(pos), long *x, long *y)
{
    *x = *y = 0;
}

void wxTextWindow::Remove(long from, long to)
{
    XawTextBlock text_block;
    text_block.firstPos = 0;
    text_block.length = 0;
    text_block.ptr = NULL;
    text_block.format = FMT8BIT;
    XawTextReplace(HWidget(), from, to, &text_block);
}

void wxTextWindow::Replace(long from, long to, char *value)
{
    XawTextBlock text_block;
    text_block.firstPos = 0;
    text_block.length = strlen(value);
    text_block.ptr = value;
    text_block.format = FMT8BIT;
    XawTextReplace(HWidget(), from, to, &text_block);
}

Bool wxTextWindow::SaveFile(char *file)
{
    modified = FALSE;
    return Bool(XawAsciiSaveAsFile(XawTextGetSource(HWidget()), file));
}

void wxTextWindow::SetEditable(Bool editable)
{
    XtVaSetValues(HWidget(), XtNeditType, (editable? XawtextEdit : XawtextRead), NULL);
}

void wxTextWindow::SetInsertionPoint(long pos)
{
    XawTextSetInsertionPoint(HWidget(), XawTextPosition(pos));
}

void wxTextWindow::SetInsertionPointEnd(void)
{
    XEvent event;
    memset(&event, 0, sizeof(event));
    XtCallActionProc(HWidget(), "end-of-file", (XEvent*)&event, NULL, 0);
}

void wxTextWindow::SetSelection(long from, long to)
{
    XawTextSetSelection(HWidget(), XawTextPosition(from), XawTextPosition(to));
}

void wxTextWindow::ShowPosition(long WXUNUSED(pos))
{
}

void wxTextWindow::WriteText(char *text)
{
    // insert text
    XawTextPosition last = GetLastPosition();
    XawTextBlock text_block;
    text_block.firstPos = 0;
    text_block.length = strlen(text);
    text_block.ptr = text;
    text_block.format = FMT8BIT;
    XawTextReplace(HWidget(), last, last, &text_block);
}

long wxTextWindow::XYToPosition(long WXUNUSED(x), long WXUNUSED(y))
{
    return 0;
}

//-----------------------------------------------------------------------------
// overload streambuf methods
//-----------------------------------------------------------------------------

// Called then the buffer is full (gcc 2.6.3) 
int wxTextWindow::overflow(int WXUNUSED(i))
{
    int   len = pptr() - pbase();
    char* txt = wxNEW char[len+1];

    strncpy(txt, pbase(), len);
    txt[len] = '\0';
    (*this) << txt;
    setp(pbase(), epptr());
    delete[] txt;
    return EOF;
}

// called then "endl" is output (gcc)
int wxTextWindow::sync(void)
{
    int   len = pptr() - pbase();
    char* txt = new char[len+1];

    strncpy(txt, pbase(), len);
    txt[len] = '\0';
    (*this) << txt;
    setp(pbase(), epptr());
    delete[] txt;
    return 0;
}

// Should not be called by a "ostream". Used by a "istream"
int wxTextWindow::underflow(void)
{
    // cerr << "TxtwinbufT::underflow " << endl;
    return EOF;
}

wxTextWindow& wxTextWindow::operator<<(char *s)
{
    WriteText(s);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(float f)
{
    char buf[100];
    sprintf(buf, "%.2f", f);
    WriteText(buf);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(double d)
{
    char buf[100];
    sprintf(buf, "%.2f", d);
    WriteText(buf);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(int i)
{
    char buf[100];
    sprintf(buf, "%i", i);
    WriteText(buf);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(long i)
{
    char buf[100];
    sprintf(buf, "%ld", i);
    WriteText(buf);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(char c)
{
    char buf[2];
    buf[0] = c;
    buf[1] = 0;
    WriteText(buf);
    return *this;
}

//-----------------------------------------------------------------------------
// callback for textWindowWidgetClass
//-----------------------------------------------------------------------------

void wxTextWindow::EventCallback(Widget WXUNUSED(w),
				 XtPointer clientData, XtPointer WXUNUSED(ptr))
{
    ((wxTextWindow*)clientData)->modified = TRUE;
}
