/*								-*- C++ -*-
 * $Id: WIN_item.cpp,v 1.2 1997-01-15 14:59:04+01 mho Exp $
 *
 * Purpose: base class for all panel items
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_item.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxItem
#define  Uses_wxPanel
#include "wx.h"
#define  Uses_FrameWidget
#include <widgets.h> // for <X11/StringDefs.h>

//-----------------------------------------------------------------------------
// wxItem constructor
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxItem, wxWindow)

wxItem::wxItem(void) : wxWindow()
{ 
    __type         = wxTYPE_ITEM;
    label_fg       = wxBLACK;
    label_font     = wxLABEL_FONT;
    label_position = wxHORIZONTAL;
    callback       = NULL;
};

//-----------------------------------------------------------------------------
// relations to panel
//-----------------------------------------------------------------------------

void wxItem::ChainToPanel(wxPanel *panel, long _style, Constdata char *name)
{
    if (!panel)
	wxFatalError("created without a panel!", name ? name : "item");

    if (!(_style & wxPRIVATE_CHILD)) {
	// printf("%s chain to panel %s\n", name, panel->GetName());
	parent = panel;
	parent->AddChild(this);
    }

    style       = _style;
    fg         = panel->GetButtonColour();
    bg         = panel->GetBackgroundColour();
    font       = panel->GetButtonFont();
    label_fg   = panel->GetLabelColour();
    label_font = panel->GetLabelFont();

    SetAppropriateLabelPosition();
}

//-----------------------------------------------------------------------------
// get and set colours
//-----------------------------------------------------------------------------

void wxItem::ChangeColours(void)
{
    Pixel label_bg_pix = (GetParent() && GetParent()->GetBackgroundColour()) ?
			 GetParent()->GetBackgroundColour()->GetPixel(&cmap) :
			 bg.GetPixel(&cmap);

    if (FWidget() && FWidget() != HWidget())
	XtVaSetValues(FWidget(),
		      XtNbackground,     label_bg_pix,
		      XtNborderColor,    label_bg_pix,
		      XtNforeground,     label_fg.GetPixel(&cmap),
		      XtNhighlightColor, label_fg.GetPixel(&cmap),
		      NULL);
    if (PWidget())
	XtVaSetValues(PWidget(),
		      XtNbackground,     label_bg_pix,
		      XtNborderColor,    label_bg_pix,
		      XtNforeground,     label_fg.GetPixel(&cmap),
		      XtNhighlightColor, label_fg.GetPixel(&cmap),
		      NULL);
    if (HWidget())
	XtVaSetValues(HWidget(),
		      XtNbackground,  bg.GetPixel(&cmap),
		      XtNforeground,  fg.GetPixel(&cmap),
		      XtNborderColor, bg.GetPixel(&cmap),
		      NULL);
}

void wxItem::SetLabelColour(wxColour &col)
{
    label_fg = col; ChangeColours();
}

void wxItem::SetLabelFont(wxFont *font)
{
    if (!font)
	return;
    label_font = font;
    if (FWidget() && HWidget() != FWidget())
	XtVaSetValues(FWidget(), XtNfont, font->GetInternalFont(), NULL);
}

//-----------------------------------------------------------------------------
// stuff for label positioning
//-----------------------------------------------------------------------------

int wxItem::GetLabelPosition (void)
{
    return label_position;
}

void wxItem::SetLabelPosition (int pos)
{
    label_position = pos;
    if (pos == wxHORIZONTAL) {
	if (style & wxVERTICAL_LABEL)
	    style -= wxVERTICAL_LABEL;
	style |= wxHORIZONTAL_LABEL;
    } else if (pos == wxVERTICAL) {
	if (style & wxHORIZONTAL_LABEL)
	    style -= wxHORIZONTAL_LABEL;
	style |= wxVERTICAL_LABEL;
    }
}

void wxItem::SetAppropriateLabelPosition(void)
{
    wxPanel *panel = (wxPanel *)GetParent();
    if (!panel)
	return;

    if (style & wxVERTICAL_LABEL)
	SetLabelPosition(wxVERTICAL);
    else if (style & wxHORIZONTAL_LABEL)
	SetLabelPosition(wxHORIZONTAL);
    else
	SetLabelPosition(panel->GetLabelPosition());
}

//-----------------------------------------------------------------------------
// functions to execute item
//-----------------------------------------------------------------------------

void wxItem::Callback(wxFunction func)
{
    callback = func;
}

void wxItem::Command(wxCommandEvent &event)
{
    ProcessCommand(event);
}

void wxItem::ProcessCommand(wxCommandEvent &event)
{
    if (callback) {
	(void)(*callback)(*this, event);
    } else {
	if (parent)
	    parent->GetEventHandler()->OnCommand(*this, event);
    }
}

//-----------------------------------------------------------------------------
// traversal routines
//-----------------------------------------------------------------------------

void wxItem::TravNext(wxEvent* event)
{
    if (FWidget())
	XtCallActionProc(FWidget(), "traverseNext",
			 (XEvent*)event->eventHandle, NULL, 0);
}

void wxItem::TravPrev(wxEvent* event)
{
    if (FWidget())
	XtCallActionProc(FWidget(), "traversePrev",
			 (XEvent*)event->eventHandle, NULL, 0);
}

void wxItem::TravHome(wxEvent* event)
{
    if (FWidget())
	XtCallActionProc(FWidget(), "traverseHome",
			 (XEvent*)event->eventHandle, NULL, 0);
}

void wxItem::TravUp(wxEvent* event)
{
    if (FWidget())
	XtCallActionProc(FWidget(), "traverseUp",
			 (XEvent*)event->eventHandle, NULL, 0);
}

void wxItem::TravDown(wxEvent* event)
{
    if (FWidget())
	XtCallActionProc(FWidget(), "traverseDown",
			 (XEvent*)event->eventHandle, NULL, 0);
}

void wxItem::TravLeft(wxEvent* event)
{
    if (FWidget())
	XtCallActionProc(FWidget(), "traverseLeft",
			 (XEvent*)event->eventHandle, NULL, 0);
}

void wxItem::TravRight(wxEvent* event)
{
    if (FWidget())
	XtCallActionProc(FWidget(), "traverseRight",
			 (XEvent*)event->eventHandle, NULL, 0);
}

//-----------------------------------------------------------------------------
// event handling for user edit mode
//-----------------------------------------------------------------------------

void wxItem::OnEvent(wxMouseEvent& event)
{
    if (parent && parent->GetUserEditMode()) {
	// forbid double click events
	if (event.ButtonDClick()) return;
	parent->GetEventHandler()->OnItemEvent(this, event);
    } else
	wxWindow::OnEvent(event);
}

void wxItem::OnMove(int x, int y)
{
    if (parent && parent->GetUserEditMode())
	parent->GetEventHandler()->OnItemMove(this, x, y);
    else
	wxWindow::OnMove(x, y);
}

void wxItem::OnSize(int w, int h)
{
    if (parent && parent->GetUserEditMode())
	parent->GetEventHandler()->OnItemSize(this, w, h);
    else
	wxWindow::OnSize(w, h);
}

void wxItem::OnLeftClick(int x, int y, int keys)
{
    if (parent && parent->GetUserEditMode())
	parent->GetEventHandler()->OnItemLeftClick(this, x, y, keys);
    else
	wxWindow::OnLeftClick(x, y, keys);
}

void wxItem::OnRightClick(int x, int y, int keys)
{
    if (parent && parent->GetUserEditMode())
	parent->GetEventHandler()->OnItemRightClick(this, x, y, keys);
    else
	wxWindow::OnRightClick(x, y, keys);
}

void wxItem::OnSelect(Bool select)
{
    if (parent && parent->GetUserEditMode()) {
	parent->GetEventHandler()->OnItemSelect(this, select);
    } else
	wxWindow::OnSelect(select);
}

//-----------------------------------------------------------------------------
// resize handles
//-----------------------------------------------------------------------------

#define HANDLE_SIZE 6

// handles are       701
// numbered this     6 2
// way:              543

void wxItem::CalcSelectionHandles(int *hx, int *hy)
{
    int xpos, ypos, width, height; GetPosition(&xpos, &ypos); GetSize(&width, &height);

    hx[7] = hx[6] = hx[5] = xpos - HANDLE_SIZE;
    hx[0] =         hx[4] = xpos + (width - HANDLE_SIZE)/2;
    hx[1] = hx[2] = hx[3] = xpos + width;

    hy[7] = hy[0] = hy[1] = ypos - HANDLE_SIZE;
    hy[6] =         hy[2] = ypos + (height - HANDLE_SIZE)/2;
    hy[5] = hy[4] = hy[3] = ypos + height;
}

void wxItem::DrawSelectionHandles(wxPanelDC *WXUNUSED(dc), Bool erase)
{
    Widget  draw_widget = parent->HWidget();
    Display *dpy = XtDisplay(draw_widget);

    // I have a window to draw on
    int hx[8], hy[8]; CalcSelectionHandles(hx, hy);
    GC  dummy, gc, clear;

    if (XfwfGetFrameGCs(draw_widget, &dummy, &dummy, &gc, &clear)) {
	for (int i = 0; i < 8; ++i)
	    XFillRectangle(dpy, XtWindow(draw_widget),
			   (erase ? clear : gc),
			   hx[i], hy[i], HANDLE_SIZE, HANDLE_SIZE);
    }
}

int wxItem::SelectionHandleHitTest(int x, int y)
{
    if (IsSelected()) {
	int hx[8], hy[8]; CalcSelectionHandles(hx, hy);

	for (int i = 0; i < 8; ++i) {
	    if (hx[i] <= x && x <= hx[i] + HANDLE_SIZE
	    &&  hy[i] <= y && y <= hy[i] + HANDLE_SIZE) {
		return i; // return hit handle number
	    }
	}
    }
    return -1; // not hit
}
