/*								-*- C++ -*-
 * $Id: UTL_changegc.cpp,v 1.2 1997-01-30 09:56:03+01 mho Exp $
 *
 * Purpose: change GC for rubberbanding
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#define  Uses_XLib
#include "wx.h"

void wxMakeXorGC(Display *dpy, GC gc, unsigned long background)
{
    XGCValues values;

    // I need old foreground pixel for XOR
    XGetGCValues(dpy, gc, GCForeground, &values);
    // set values
    values.foreground        ^= background;
    values.function           = GXxor;
    values.line_width         = 2;
    values.subwindow_mode     = IncludeInferiors;
    values.graphics_exposures = TRUE;
    // change GC
    XChangeGC(dpy, gc,
	      GCForeground | GCFunction | GCLineWidth |
	      GCSubwindowMode | GCGraphicsExposures,
	      &values);
}

void wxMakeCopyGC(Display *dpy, GC gc, unsigned long background)
{
    XGCValues values;

    // I need old foreground pixel for XOR
    XGetGCValues(dpy, gc, GCForeground, &values);
    // set values
    values.foreground        ^= background;
    values.function           = GXcopy;
    values.line_width         = 0;
    values.subwindow_mode     = ClipByChildren;
    values.graphics_exposures = TRUE;
    // change GC
    XChangeGC(dpy, gc,
	      GCForeground | GCFunction | GCLineWidth |
	      GCSubwindowMode | GCGraphicsExposures,
	      &values);
}

void wxMakeNoClipGC(Display *dpy, GC gc)
{
    XGCValues values;

    values.subwindow_mode = IncludeInferiors;
    XChangeGC(dpy, gc, GCSubwindowMode, &values);
}

void wxMakeClipGC(Display *dpy, GC gc)
{
    XGCValues values;

    values.subwindow_mode = ClipByChildren;
    XChangeGC(dpy, gc, GCSubwindowMode, &values);
}
