/******************************************************************************
 Iconify

 ******************************************************************************/

void
JXWindow::Iconify()
{
	// change the initial_state hint

	XWMHints wmHints;

	XWMHints* origHints = XGetWMHints(*itsDisplay, itsXWindow);
	if (origHints != NULL)
		{
		wmHints = *origHints;
		XFree(origHints);
		}
	else
		{
		wmHints.flags = 0;
		}

	wmHints.flags        |= StateHint;
	wmHints.initial_state = IconicState;
	XSetWMHints(*itsDisplay, itsXWindow, &wmHints);

	// take other necessary actions

	if (IsVisible())
		{
		// We don't modify itsIsIconifiedFlag here because the procedure might
		// fail.  We wait for an UnmapNotify event.

		XIconifyWindow(*itsDisplay, itsXWindow, itsDisplay->GetScreen());
		}
	else
		{
		if (!itsIsIconifiedFlag)
			{
			itsIsIconifiedFlag = kTrue;
			Broadcast(Iconified());
			}
		}
}

/******************************************************************************
 Deiconify

 ******************************************************************************/

void
JXWindow::Deiconify()
{
	// change the initial_state hint

	XWMHints wmHints;

	XWMHints* origHints = XGetWMHints(*itsDisplay, itsXWindow);
	if (origHints != NULL)
		{
		wmHints = *origHints;
		XFree(origHints);
		}
	else
		{
		wmHints.flags = 0;
		}

	wmHints.flags        |= StateHint;
	wmHints.initial_state = NormalState;
	XSetWMHints(*itsDisplay, itsXWindow, &wmHints);

	// take other necessary actions

	if (IsVisible())
		{
		// We don't modify itsIsIconifiedFlag here because we already deal
		// with it in HandleMapNotify().

		XMapWindow(*itsDisplay, itsXWindow);
		}
	else
		{
		if (itsIsIconifiedFlag)
			{
			itsIsIconifiedFlag = kFalse;
			Broadcast(Deiconified());
			}
		}
}
