//=======================================================================
//  mycmdwin.h:	Header file for minimal prototype V application
//  Copyright (C) 1995  Bruce E. Wampler
//
//  This program is part of the V C++ GUI Framework example programs.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=======================================================================

//
//  Files required for minimal application:
//	protoapp.h	Header for the min app
//	protoapp.cxx:	Source code for min app
//	mydialog.h:	Header for sample modeless dialog
//	mydialog.cxx:	Source for sample modeless dialog
//	mymodal.h:	Header for sample modal dialog
//	mymodal.cxx	Soruce for sample modal dialog
//
//	While these files were generated by hand, they are intended to
//	serve as an example of files that could have been generated by
//	the V interface generator (Vigr)
//

  // Derive a window from the vStandardWindow class

#ifndef MYCMDWIN_H
#define MYCMDWIN_H

#include <v/vcmdwin.h>	// So we can use vCmdWindow
#include <v/vmenu.h>	// For the menu pane
#include <v/vstatusp.h>	// For the status pane
#include <v/vcmdpane.h> // command pane
#include <v/vpen.h>	// for a pen

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include "mydialog.h"	// user defined: myDialog
#include "mymodal.h"	// user defined: myModalDialog
#include "mycanvas.h"	// user defined: myCanvasPane

    class myCmdWindow : public vCmdWindow
      {
	friend int AppMain(int, char**);	// allow AppMain access

      public:		//---------------------------------------- public
	myCmdWindow(char*, int, int); // Constructor with size
	myCmdWindow(const myCmdWindow&);   // Constructor with size
	virtual ~myCmdWindow();		// Destructor
	virtual void WindowCommand(ItemVal id, ItemVal val, CmdType cType);
	virtual void KeyIn(vKey keysym, unsigned int shift); // for key strokes

      protected:	//--------------------------------------- protected

      private:		//--------------------------------------- private

	// Each user CmdWindow should conform to a "Standard" window,
	// which includes a menu bar, a canvas, an optional command bar,
	// and an optional status bar.

	vMenuPane* myMenu;		// For the menu bar
	myCanvasPane* myCanvas;		// For the canvas
	vStatusPane* myStatus;		// For the status bar
	vCommandPane* myCmdPane;	// for the command pane

	// Each user CmdWindow will probably have some dialogs and
	// subwindows. Declare pointers to each instance here.

	myDialog* sampleDialog;
	myModalDialog* sampleModalDialog;

	// other stuff
	vPen _pen;
	int changePen;
      };
#endif
