#! /usr/bin/env python

"""Demonstration of using t1lib with Tkinter."""

import ImageTk
import t1lib
import t1Imaging
import Tkinter


class DemoDisplay(Tkinter.Toplevel):
    def __init__(self, master):
	Tkinter.Toplevel.__init__(self, master)
	self.title("Display Window")
	self.label = Tkinter.Label(self, text="Display Window",
				   borderwidth=0)
	self.label.pack()
	self.protocol("WM_DELETE_WINDOW", master.quit)

    def setGlyph(self, glyph):
	self.photo = ImageTk.PhotoImage(glyph)
	self.glyph = glyph
	self.label["image"] = self.photo

    def destroy(self):
	Tkinter.Toplevel.destroy(self)
	self.label = None
	self.photo = None


class DemoDialog(Tkinter.Toplevel):
    """A bunch of controls that affect a display window."""

    def __init__(self, master, display):
	Tkinter.Toplevel.__init__(self, master)
	self.title("Display Controls")
	self.display = display
	self.__setters = {}
	self.create_widgets()
	self.protocol("WM_DELETE_WINDOW", master.quit)

    def create_widgets(self):
	self.__labels = []
	# create selection box for font:
	import _t1lib
	map(_t1lib.LoadFont, range(_t1lib.Get_no_fonts()))
	names = tuple(map(_t1lib.GetFontName, range(_t1lib.Get_no_fonts())))
	namewidth = apply(max, tuple(map(len, names)))
	self.font_var = Tkinter.StringVar()
	self.font_var.set(names[0])
	font_selector = apply(
	    Tkinter.OptionMenu, (self, self.font_var) + names)
	font_selector.configure(width=namewidth, anchor=Tkinter.W,
				highlightthickness=0)
	self.string_var, entry = self.add_entry("String:", Tkinter.StringVar)
	self.add_row("Font:", font_selector)
	self.size_var, x = self.add_entry("Size:", Tkinter.DoubleVar, 100.0, 8)
	self.spaceoff_var, x = self.add_entry("Space offset:",
					      Tkinter.DoubleVar, 0.0, 8)
	self.angle_var, x = self.add_entry("Rotation:",
					   Tkinter.DoubleVar, 0.0, 8)
	self.kerning_flag = self.add_boolean("Kerning")
	self.aa_flag = self.add_boolean("Anti-aliasing")
	self.end_rows()
	entry.focus_set()

    def add_entry(self, text, varclass, value=None, width=None):
	var = varclass()
	if value is not None:
	    var.set(value)
	entry = Tkinter.Entry(self, textvariable=var, width=width)
	entry.bind("<Return>", self.doit)
	if width:
	    expand = None
	else:
	    expand = 1
	self.add_row(text, entry, expand)
	return var, entry

    def add_row(self, text, widget, expand=None):
	frame = Tkinter.Frame(self)
	label = Tkinter.Label(frame, text=text, anchor=Tkinter.E)
	label.pack(side=Tkinter.LEFT)
	widget.pack(side=Tkinter.LEFT, in_=frame, fill=Tkinter.X,
		    anchor=Tkinter.W, expand=expand)
	widget.tkraise()
	frame.pack(fill=Tkinter.X, padx=4, pady=3)
	self.__labels.append(label)

    def add_rule(self, size=2):
	Tkinter.Frame(self, height=size, borderwidth=1, relief=Tkinter.SUNKEN
		      ).pack(fill=Tkinter.X)

    def end_rows(self):
	wid = 0
	for label in self.__labels:
	    wid = max(wid, len(label["text"]))
	for label in self.__labels:
	    label["width"] = wid

    def add_boolean(self, text):
	var = Tkinter.BooleanVar()
	widget = Tkinter.Checkbutton(self, text=text, variable=var,
				     anchor=Tkinter.W, command=self.doit)
	self.add_row("", widget, 1)
	return var

    def doit(self, event=None):
	s = self.string_var.get()
	if s:
	    self.display.setGlyph(self.getSetter().setString(s))

    def getSetter(self):
	key = self.getSetterKey()
	try:
	    return self.__setters[key]
	except KeyError:
	    pass
	fontname, size, kerning, spaceoff, angle, aa = key
	font = t1lib.getFont(fontname)
	if aa:
	    bpp = 32
	else:
	    bpp = 1
	setter = t1Imaging.ImagingSetter(font, size, kerning=kerning, bpp=bpp,
					 spaceoff=spaceoff, angle=angle)
	self.__setters[key] = setter
	return setter

    def getSetterKey(self):
	fontname = self.font_var.get()
	size = self.size_var.get()
	kerning = self.kerning_flag.get()
	spaceoff = self.spaceoff_var.get()
	angle = self.angle_var.get()
	aa = self.aa_flag.get()
	return fontname, size, kerning, spaceoff, angle, aa


def main():
    root = Tkinter.Tk()
    root.withdraw()
    display = DemoDisplay(root)
    controller = DemoDialog(root, display)
    root.mainloop()


if __name__ == "__main__":
    main()
