#ifndef _URKFLTR__
#define _URKFLTR__

#include <ncbi.h>
#include <seqport.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MAXSEQCHUNK           262144

#define NA_FILTER             0
#define NA_FILTER_GC          1
#define NA_FILTER_AT          2
#define NA_FILTER_PUR         3
#define NA_FILTER_PYR         4

#define AA_FILTER_COMP        100
#define AA_FILTER_COMP_HOPP   101
#define AA_FILTER_COMP_KYTE   102

typedef struct filterdata
{
  Int4       window, filtertype, filtersize;
  CharPtr    filterdatafile;
  CharPtr    res;
  FloatHiPtr scr;
  FloatHi    maxscr;
} FilterDat, PNTR FilterDatPtr;

extern Int4 ReadFilterData (FilterDatPtr fltp);

extern FilterDatPtr FilterDatNew (Int4 filtertype, Int4 window);
extern FilterDatPtr FilterDatFree (FilterDatPtr fltp);

extern FloatHiPtr FilterSeq (CharPtr seq, Int4 start, Int4 end,
                             FilterDatPtr fltp);

extern FloatHiPtr FilterSeqPort (SeqPortPtr spp,
                                 Int4 start, Int4 end,
                                 FilterDatPtr fltp);

extern FloatHiPtr FilterBioseq (BioseqPtr bsp,
                                Int4 start, Int4 end,
                                FilterDatPtr fltp);

extern FloatHiPtr FilterSeqLoc (SeqLocPtr slp,
                                FilterDatPtr fltp);

extern SeqLocPtr FilterFilter (FloatHiPtr score, FloatHi maxscore,
                               Int4 window, FloatHi percentcut,
                               Int4 length, SeqIdPtr sip,
                               Boolean flagMeld, Boolean flagHighPass);

#ifdef __cplusplus
}
#endif

#endif
