#ifndef _CONSORT__
#define _CONSORT__

#include <ncbi.h>
#include <accentr.h>
#include <urktree.h>

#ifdef __cplusplus
extern "C" {
#endif

#define CONMATSIZE    512

/* codon usage tree from genome */

extern TreeNodePtr ConsortSeqEntry (SeqEntryPtr sep);

/* exploration:  ORFs related by codon usage */

extern Int4Ptr NewCodonTable (void);
extern Int4Ptr FreeCodonTable (Int4Ptr cutp);
extern Int4Ptr CodonTableFromSeqLoc (BioseqPtr bsp, SeqLocPtr slp);
extern void AddSeqLocToCodonTable (Int4Ptr cutp, BioseqPtr bsp,
                                   SeqLocPtr slp, Boolean flagAdd);
extern Int4Ptr MergeCodonTables (Int4Ptr cutp1, Int4Ptr cutp2);

extern FloatHi Confide (Int4Ptr cutgene, Int4Ptr cutgbl);

#ifdef __cplusplus
}
#endif

#endif
