#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "wnlib.h"
#include "wnasrt.h"
#include "wnmem.h"

#include "wnconj.h"


#define NUM_VARS  2


local int grad_count,func_count;


local void gradient(double grad[],double vect[])
{
  double x1,x2;
  double diff1,diff2;
  double ob;

  printf("gradient.  count = %d\n",grad_count);
  ++grad_count;

  x1 = vect[0];
  x2 = vect[1];

  diff1 = x2-x1*x1*x1;
  diff2 = 1.0-x1;

  grad[0] = -600.0*diff1*x1*x1 - 2.0*diff2;
  grad[1] = 200.0*diff1;
}


/*
  function = 100(x2-x1^3)^2 + (1-x1)^2
*/
local double function(double vect[])
{
  double x1,x2;
  double diff1,diff2;
  double ob;

  x1 = vect[0];
  x2 = vect[1];

  diff1 = x2-x1*x1*x1;
  diff2 = 1.0-x1;

  ob = (100.0*diff1*diff1 + diff2*diff2);

  printf("ob = %lg,func_count = %d\n",ob,func_count);
  ++func_count;

  return(ob);
}


void main(void)
{
  double vect[2],delta_vect[2];
  int code;
  double val_min;

  /*
  wn_gpmake("no_free");
  */

  grad_count = func_count = 0;

  vect[0] = -1.2;
  vect[1] = -1.0;

  delta_vect[0] = 0.001;
  delta_vect[1] = 0.001;

  wn_conj_gradient_method(&code,&val_min,vect,NUM_VARS,(function),(gradient),WN_IHUGE);
  /*
  wn_conj_direction_method(&code,&val_min,vect,NUM_VARS,(function),WN_IHUGE);
  wn_conj_gradient_diff_method(&code,&val_min,vect,delta_vect,NUM_VARS,(function),WN_IHUGE);
  */

  printf("code = %d\n",code);
  printf("objective = %lg\n",val_min);
  val_min = function(vect);
  printf("actual objective = %lg\n",val_min);
  wn_print_vect(vect,NUM_VARS);
  printf("grad_count = %d,func_count = %d\n",grad_count,func_count);
}
