/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#ifndef wnbtrH
#define wnbtrH


#include "wnlib.h"
#include "wnmem.h"


#define  WN_B_MIN    (-3)
#define  WN_B_MAX    3
#define  WN_B_LT     (-2)
#define  WN_B_GT     2
#define  WN_B_LE     (-1)
#define  WN_B_GE     1
#define  WN_B_EQ     0


typedef struct wn_btree_struct *wn_btree;
typedef struct wn_bhandle_struct *wn_bhandle;

struct wn_btree_struct
{
  wn_bhandle handle_tree;

  int (*pcompare_keys_func)(ptr key1,ptr key2);
  void (*palloc_copy_key_func)(ptr *pkey,ptr key);
  void (*pfree_key_func)(ptr key);

  wn_memgp group;
};

struct wn_bhandle_struct
{
  ptr contents,key;

  int level,count;

  wn_bhandle left_child,right_child,parent;
};
  

void wn_mkbtree
(
  wn_btree *ptree,
  int (*pcompare_keys_func)(ptr key1,ptr key2),
  void (*palloc_copy_key_func)(ptr *pkey,ptr key),
  void (*pfree_key_func)(ptr key)
);
void wn_freebtree(wn_btree tree);

void wn_bget(wn_bhandle *phandle,wn_btree tree,ptr key,int compare);
void wn_bins(wn_bhandle *phandle,wn_btree tree,ptr key);
void wn_bdel(wn_bhandle handle,wn_btree tree);
void wn_bmove(wn_bhandle handle,wn_btree tree,ptr new_key);
void wn_bget_index_of_handle(int *pindex,wn_btree tree,wn_bhandle handle);
void wn_bget_handle_of_index(wn_bhandle *phandle,wn_btree tree,int index);

int wn_bcount(wn_btree tree);
void wn_bact
(
  wn_btree tree,
  void (*paction)(wn_bhandle handle),
  ptr low_key,
  int low_compare,
  ptr high_key,
  int high_compare
);

void wn_bverify(wn_btree tree);


#endif


