/**
 *
 * $Id: Test.c,v 1.6 1998/10/26 21:46:58 rwscott Exp $
 *
 * Copyright (C) 1996 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#include <stdio.h>
#include <X11/X.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

/* ************** */

int GlobalErrors = 0;

typedef struct
{
    Boolean autoExit;
    int exitDelay;
    int geometrySlop;
}
AppResources_t, *AppResourcesPtr;

static AppResources_t AppResources;

static XtResource resources[] =
{
    {"autoExit", "AutoExit", XtRBoolean, sizeof(Boolean), XtOffset(AppResourcesPtr, autoExit), XtRImmediate, (void *)False},
    {"exitDelay", "ExitDelay", XtRInt, sizeof(int), XtOffset(AppResourcesPtr, exitDelay), XtRImmediate, (void *)0},
    {"geometrySlop", "GeometrySlop", XtRInt, sizeof(int), XtOffset(AppResourcesPtr, geometrySlop), XtRImmediate, (void *)0},
};

/* ************** */

char *
XdbGeometryResult2String(XtGeometryResult r)
{
    switch (r)
    {
    case XtGeometryYes:
	return "Yes";

    case XtGeometryNo:
	return "No";

    case XtGeometryAlmost:
	return "Almost";

    case XtGeometryDone:
	return "Done";

    default:
	return "(invalid geometry result)";
    }
}

/* ************** */

char *
XdbWidgetGeometry2String(XtWidgetGeometry *g)
{
    static char o1[128], o2[128], b[20], *out = NULL;
    int i;

    if (g == NULL)
    {
	return "NULL_GEOMETRY";
    }

    if (g->request_mode == 0)
    {
	return "GEOMETRY_NO_FIELDS";
    }

/* Some magic to ensure you can call this sucker twice in one C function call */
    if (out == &o1[0])
    {
	out = &o2[0];
    }
    else
    {
	out = &o1[0];
    }

    out[0] = '\0';
    if (g->request_mode & CWX)
    {
	sprintf(b, "x %d ", g->x);
	strcat(out, b);
    }
    if (g->request_mode & CWY)
    {
	sprintf(b, "y %d ", g->y);
	strcat(out, b);
    }
    if (g->request_mode & CWWidth)
    {
	sprintf(b, "w %d ", g->width);
	strcat(out, b);
    }
    if (g->request_mode & CWHeight)
    {
	sprintf(b, "h %d ", g->height);
	strcat(out, b);
    }
    if (g->request_mode & CWBorderWidth)
    {
	sprintf(b, "bw %d ", g->border_width);
	strcat(out, b);
    }

    for (i = 0; out[i]; i++)
    {
    }

    if (i > 0 && out[i - 1] == ' ')
    {
	out[i - 1] = '\0';
    }

    return out;
}

/* ************** */

static void
Initialize(Widget w)
{
    static Boolean inited = False;

    if (!inited)
    {
	XtGetApplicationResources(w,
				  &AppResources,
				  resources, XtNumber(resources),
				  NULL, 0);
	XSynchronize(XtDisplay(w), True);
    }
}

/* ************** */

int
LessTifTestGetSlop(Widget w)
{
	Initialize(w);
	return(AppResources.geometrySlop);
}

/* ************** */

static void
Exit()
{
    printf("exit status >%i<\n", GlobalErrors);
    exit(GlobalErrors);
}

/* ************** */

static void
Popup(Widget w, Boolean *mapped, XEvent *event)
{
    if (event->type == MapNotify)
    {
	*mapped = True;
    }
}

/* ************** */

static void
TimeOut(Boolean *mapped)
{
    *mapped = True;
}

/* ************** */

static void
Delay(Widget w)
{
    Boolean mapped = False;

    XtAppAddTimeOut(XtWidgetToApplicationContext(w), AppResources.exitDelay, (void *)TimeOut, (XtPointer)&mapped);
    while (!mapped)
    {
	XtAppProcessEvent(XtWidgetToApplicationContext(w), XtIMAll);
    }
}

/* ************** */

int
LessTifTestResizeWidget(Widget w, Dimension wt, Dimension ht)
{
Dimension bw;

    Initialize(w);
    XtVaGetValues(w,
    	XtNborderWidth, &bw,
    	NULL);
    XtResizeWidget(w, wt, ht, bw);
    XSync(XtDisplay(w), False);
    while (XtAppPending(XtWidgetToApplicationContext(w)))
    {
	XtAppProcessEvent(XtWidgetToApplicationContext(w), XtIMAll);
	XFlush(XtDisplay(w));
    }
    Delay(w);
    return(0);
}

/* ************** */

int
LessTifTestPushButton(Widget w)
{
    Initialize(w);
    XtCallActionProc(w, "ArmAndActivate", NULL, NULL, 0);
    XSync(XtDisplay(w), False);
    while (XtAppPending(XtWidgetToApplicationContext(w)))
    {
	XtAppProcessEvent(XtWidgetToApplicationContext(w), XtIMAll);
	XFlush(XtDisplay(w));
    }
    Delay(w);
    return(0);
}

/* ************** */

int
LessTifTestWaitForIt(Widget w)
{
    XWindowAttributes window_attributes;
    Boolean mapped = False;

    Initialize(w);
    XGetWindowAttributes(XtDisplay(w), XtWindow(w), &window_attributes);
    if (window_attributes.map_state == IsUnmapped)
    {

	XtAddEventHandler(w, StructureNotifyMask, False, (void *)Popup, (XtPointer)&mapped);
	XSync(XtDisplay(w), False);
	while (!mapped || XtAppPending(XtWidgetToApplicationContext(w)))
	{
	    XtAppProcessEvent(XtWidgetToApplicationContext(w), XtIMAll);
	    XFlush(XtDisplay(w));
	}
	XtRemoveEventHandler(w, StructureNotifyMask, False, (void *)Popup, (XtPointer)&mapped);
    }
    Delay(w);
    return(0);
}

/* ************** */

int
LessTifTestMainLoop(Widget w)
{
    Initialize(w);
    if (!AppResources.autoExit)
    {
	XtAppMainLoop(XtWidgetToApplicationContext(w));
    }
    else
    {
	LessTifTestWaitForIt(w);
	Delay(w);
	Exit();
    }
    return(0);
}

/* ************** */
