# Check to see if we're running under Cygwin32, without using
# AC_CANONICAL_*.  If so, set output variable EXEEXT to ".exe".
# Otherwise set it to "".

dnl AM_CYGWIN32()
dnl You might think we can do this by checking for a cygwin32-specific
dnl cpp define.  We can't, because cross-compilers that target
dnl cygwin32 don't use the .exe suffix.  I don't know why.
AC_DEFUN(AM_CYGWIN32,
[AC_CACHE_CHECK(for Cygwin32 environment, am_cv_cygwin32,
[cat > conftest.$ac_ext << 'EOF'
int main () {
/* Nothing.  */
return 0; }
EOF
if AC_TRY_EVAL(ac_link) && test -s conftest.exe; then
   am_cv_cygwin32=yes
else
   am_cv_cygwin32=no
fi
rm -f conftest*])
EXEEXT=
test "$am_cv_cygwin32" = yes && EXEEXT=.exe
AC_SUBST(EXEEXT)])


# serial 1

AC_DEFUN(AM_WITH_DMALLOC,
[AC_MSG_CHECKING(if malloc debugging is wanted)
AC_ARG_WITH(dmalloc,
[  --with-dmalloc          use dmalloc, as in
                          ftp://ftp.letters.com/src/dmalloc/dmalloc.tar.gz],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(WITH_DMALLOC)
  LIBS="$LIBS -ldmalloc"
  LDFLAGS="$LDFLAGS -g"
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])
])

# Check to see if we're running under EMX, without using
# AC_CANONICAL_*.  If so, set output variable EXEEXT to ".exe".
# Otherwise set it to "".

dnl AM_EMX()
dnl This lines were done with a quick look to the cygwin neighbour
dnl
AC_DEFUN(AM_EMX,  
[AC_CACHE_CHECK(for EMX environment, am_cv_emx,
[cat > conftest.$ac_ext << 'EOF' 
int main () { 
/* Nothing.  */
return 0; }
EOF
if AC_TRY_EVAL(ac_link -Zexe) && test -s conftest.exe; then
   am_cv_emx=yes
   x_includes=$X11ROOT/XFree86/include
   x_libraries=$X11ROOT/XFree86/lib
else
   am_cv_emx=no
fi
rm -f conftest*])
EXEEXT=
test "$am_cv_emx" = yes && EXEEXT=.exe
AC_SUBST(EXEEXT)])
