#include "obgtkWidget.h"
#ifdef GTK_HAVE_FEATURES_1_1_0
#include "obgtkAccelGroup.h"
#else
#include "obgtkAcceleratorTable.h"
#endif

@implementation Gtk_Widget
- castGtkWidget:(GtkWidget *)castitem
{
  self = [super castGtkObject:GTK_OBJECT(castitem)];
  gtkwidget = castitem;
  return self;
}

- (Gtk_Widget *)get_parent
{
  if(!gtkwidget->parent)
    return (Gtk_Widget *)0;
  else
    return (Gtk_Widget *)
      gtk_object_get_data_by_id(GTK_OBJECT(gtkwidget->parent), OBJC_ID());
}

- unparent
{
  gtk_widget_unparent(gtkwidget);
  return self;
}

- show
{
  gtk_widget_show(gtkwidget);
  return self;
}

- hide
{
  gtk_widget_hide(gtkwidget);
  return self;
}

- map
{
  gtk_widget_map(gtkwidget);
  return self;
}

- unmap
{
  gtk_widget_unmap(gtkwidget);
  return self;
}

- realize
{
  gtk_widget_realize(gtkwidget);
  return self;
}

- unrealize
{
  gtk_widget_unrealize(gtkwidget);
  return self;
}

- draw:(GdkRectangle *) area
{
  gtk_widget_draw(gtkwidget, area);
  return self;
}

- draw_focus
{
  gtk_widget_draw_focus(gtkwidget);
  return self;
}

- draw_default
{
  gtk_widget_draw_default(gtkwidget);
  return self;
}

- draw_children
{
  gtk_widget_draw_children(gtkwidget);
  return self;
}

- size_request:(GtkRequisition *)requisition
{
  gtk_widget_size_request(gtkwidget, requisition);
  return self;
}

- size_allocate:(GtkAllocation *) allocation
{
  gtk_widget_size_allocate(gtkwidget, allocation);
  return self;
}

#ifdef GTK_HAVE_FEATURES_1_1_0
- add_accelerator:(gchar *)asignal
		 :(Gtk_AccelGroup *) group
	   keySym:(gchar)akey
      modifierSet:(guint8)modifiers
		 :(GtkAccelFlags)accel_flags
{
  gtk_widget_add_accelerator(gtkwidget,
			     asignal,
			     group->gtkaccelgroup,
			     akey,
			     modifiers,
			     accel_flags);
  return self;
}
#else
- install_accelerator:(Gtk_AcceleratorTable *) table
	   signalName:(gchar *)asignal
	       keySym:(gchar)akey
	  modifierSet:(guint8)modifiers
{
  gtk_widget_install_accelerator(gtkwidget,
				 table->gtkacceleratortable,
				 asignal,
				 akey,
				 modifiers);
  return self;
}
#endif

- (gint)event:(GdkEvent *)event
{
  return gtk_widget_event(gtkwidget, event);
}

- activate
{
  gtk_widget_activate(gtkwidget);
  return self;
}

- reparent:(Gtk_Widget *)new_parent
{
  gtk_widget_reparent(gtkwidget,new_parent->gtkwidget);
  return self;
}

- popup:
   locX:(gint)x
   locY:(gint)y
{
  gtk_widget_popup(gtkwidget, x, y);
  return self;
}

- (gint)intersect:
	     area:(GdkRectangle *)anArea
     intersection:(GdkRectangle *)aRectangle
{
  return gtk_widget_intersect(gtkwidget, anArea, aRectangle);
}

- (gint)basic
{
  return gtk_widget_basic(gtkwidget);
}

- grab_focus
{
  gtk_widget_grab_focus(gtkwidget);
  return self;
}

- grab_default
{
  gtk_widget_grab_default(gtkwidget);
  return self;
}

- set_name:(gchar *)name
{
  gtk_widget_set_name(gtkwidget, name);
  return self;
}

- set_state:(GtkStateType) state
{
  gtk_widget_set_state(gtkwidget, state);
  return self;
}

- set_sensitive:(gint)sensitive
{
  gtk_widget_set_sensitive(gtkwidget, sensitive);
  return self;
}

- set_parent:(Gtk_Widget *) parent
{
  gtk_widget_set_parent(gtkwidget, parent->gtkwidget);
  return self;
}

- set_style:(GtkStyle *) style
{
  gtk_widget_set_style(gtkwidget, style);
  return self;
}

- set_uposition:(gint)x
               :(gint)y
{
  gtk_widget_set_uposition(gtkwidget, x, y);
  return self;
}

- set_usize:(gint) awidth
     height:(gint) aheight
{
  gtk_widget_set_usize(gtkwidget, awidth, aheight);
  return self;
}

- set_events:(gint) events
{
  gtk_widget_set_events(gtkwidget, events);
  return self;
}

- (Gtk_Widget *) get_toplevel
{
  return [[Gtk_Widget alloc] castGtkWidget:(GtkWidget *)gtk_widget_get_toplevel(gtkwidget)];
}

- (Gtk_Widget *) get_ancestor:(gint) type
{
  return [[Gtk_Widget alloc] castGtkWidget:(GtkWidget *)
	gtk_widget_get_ancestor(gtkwidget, type)];
}
@end
