/* obgtkCalendar.h: Copyright (C) 1998 Free Software Foundation
 * Objective-C wrappings for GNOME UI routines.
 * Written by: Bertrand Guiheneuf <Bertrand.Guiheneuf@inria.fr>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef OBGTK_LAYOUT_H
#define OBGTK_LAYOUT_H 1

#include <gnome.h>
#include "obgtk/obgtk.h"


#include <obgtk/obgtkContainer.h>
#include <libgnomeui/gtklayout.h>

@interface Gtk_Layout : Gtk_Container
{
@public
GtkLayout *gtklayout;
}

- castGtkLayout:(GtkLayout *) castitem;
- initWithAdjustmentInfo:(Gtk_Adjustment *) hadjustment
	     vadjustment:(Gtk_Adjustment *) vadjustment
  ;
- put: (Gtk_Widget *) widget
    x: (gint) x
    y: (gint) y
  ;
- move: (Gtk_Widget *) widget
    x: (gint) x
    y: (gint) y
  ;
- set_size: (gint) width
    height: (gint) height
  ;
- freeze;
- thaw;
- (Gtk_Adjustment *) get_hadjustment;
- (Gtk_Adjustment *) get_vadjustment;
- set_hadjustment: (Gtk_Adjustment *) adjustment;
- set_vadjustment: (Gtk_Adjustment *) adjustment;

@end

#endif /* OBGTK_LAYOUT_H */
