/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: invalidate.c,v $
 * Revision 1.5  1998/09/02 02:21:46  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.4  1998/08/23 18:57:12  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.3  1998/08/16 18:40:56  ortalo
 * A new version, STILL IN VERY ALPHA STATE... (Be patient.)
 * (However, this version is a little better... :-)
 *
 * Revision 1.2  1998/08/11 22:10:09  ortalo
 * Incorporated the changes made by Tristan Wibberley. The code is
 * still in alpha development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#include <stdlib.h>
#include <stdio.h>

#include "internal.h"

int _gwt_invalidate(gwt_window_t win, gwt_region_t region)
{
	return gwt_region_union(win->invalid, region);
}

int _gwt_validate(gwt_window_t win, gwt_region_t region)
{
	return gwt_region_difference(win->invalid, region);
}

int gwt_invalidate(gwt_window_t win, gwt_region_t region)
{
	return _gwt_invalidate(win, region);
}

int gwt_validate(gwt_window_t win, gwt_region_t region)
{
	return _gwt_validate(win, region);
}

int gwt_invalidate_all(gwt_window_t win)
{
	int ret;
	gwt_region_t visible;

	gwt_region_create(&visible);
	gwt_region_copy(visible, win->visible);
	ret = _gwt_invalidate(win, visible);
	gwt_region_destroy(visible);
	return ret;
}

int gwt_validate_all(gwt_window_t win)
{
	int ret;
	gwt_region_t visible;

	gwt_region_create(&visible);
	gwt_region_copy(visible, win->visible);
	ret = _gwt_validate(win, visible);
	gwt_region_destroy(visible);
	return ret;
}

int gwt_get_invalid_region(gwt_region_t r, gwt_window_t win)
{
	return gwt_region_copy(r, win->invalid);
}



/*****************************************************************
 *               Cover/Uncovering for visible regions
 */

void gwt_visible_setvisinv_family(gwt_window_t win)
{
	/* TODO: Check those "is window visible" tests, I'm not sure... */
	gwt_window_t sibling;

	gwt_visible_setvisinv(win);
	gwt_visible_setvisinv_children(win);
	
	if (win->level==0) return;

	sibling=GWT_Z_DOWN(win);
	while ( sibling != NULL) {
		if (sibling->hidden!=1) {
			gwt_visible_setvisinv(sibling);
			gwt_visible_setvisinv_children(sibling);
		}
		sibling=GWT_Z_DOWN(sibling);
	}
	gwt_visible_setvisinv(win->wparent);

}

void gwt_visible_setvisinv_children(gwt_window_t win)
{
	/* TODO: Check those "is window visible" tests, I'm not sure... */
	gwt_window_t child;

	child=GWT_Z_TOP_CHILD(win);
	while ( child != NULL) {
		if (child->hidden!=1) {
			gwt_visible_setvisinv(child);
			gwt_visible_setvisinv_children(child);
		}
		child=GWT_Z_DOWN(child);
	}
}

void gwt_set_invalidation(gwt_window_t win, gwt_region_t oldvisible)
{
	gwt_region_t temp;
	gwt_region_create(&temp);

	gwt_region_copy(temp, win->visible);
	gwt_region_difference(temp, oldvisible);
	gwt_invalidate(win, temp);

	gwt_region_copy(temp, oldvisible);
	gwt_region_difference(temp, win->visible);
	gwt_validate(win, temp);

	gwt_region_destroy(temp);
}

void gwt_visible_setvisinv(gwt_window_t win)
{
	gwt_window_t parent, child;
	gwt_region_t oldvisible;

	gwt_region_create(&oldvisible);

	gwt_region_copy(win->_external_visible, win->_family_visible);

	if (win->level>0) {
#if 0	/* _family_visible already doesn't overlap with siblings, (TODO: check this) */
		sibling=GWT_Z_UP(win);
		while (sibling!=NULL) {
			/* This too, but doesn't show up in test3 */
			gwt_region_difference(win->_external_visible, sibling->_family_visible);
			sibling=GWT_Z_UP(sibling);
		}
#endif
/*
 * _family_visible is what's not covered by siblings, but now we need what of that isn't
 * covered by the parent, grandparent, great grandparent, etc...
 */
		parent=win;
		while (parent->level>0) {
			parent=parent->wparent;
			/* because of this line, _external_visible must be set for parent already */
			gwt_region_intersection(win->_external_visible, parent->_external_visible);
		}
	}

	gwt_region_copy(oldvisible, win->visible);
	gwt_region_copy(win->visible, win->_external_visible);

	child=GWT_Z_TOP_CHILD(win);
	while (child!=NULL) {
		/*
		 * This is affected by the tt_region.c bug, see
		 * test3 with the white bits drawn *after* the red bits.
		 * It doesn't seem to appear in test2 though (draw red after green)
		 */
		gwt_region_difference(win->visible, child->_external_visible);
		child=GWT_Z_DOWN(child);
	}

	/*
	 * we've got the new visible now, so we can calculate the invalid region
	 */

	gwt_set_invalidation(win, oldvisible);
	gwt_region_destroy(oldvisible);
}

int gwt_visible_lower(gwt_window_t old_z, gwt_window_t new_z, gwt_window_t win)
{
	/*
	 * old_z is the window that was below win,
         * new_z is the window that is win (or where win would be now - NULL is bottom).
	 * Should be called only after placing win in it's rightful place.
	 */
	gwt_region_t temp;
	gwt_window_t sibling;
	gwt_region_create(&temp);
	
	sibling=old_z;
	while ( sibling != new_z ) {
		if (sibling->hidden!=1) {
			gwt_region_copy(temp, sibling->geometry);
			gwt_region_intersection(temp, win->_family_visible);
			gwt_region_union(sibling->_family_visible, temp);
			gwt_region_difference(win->_family_visible, temp);
		}
		sibling=GWT_Z_DOWN(sibling);
	}
#if 0	/* Segfault! check tt_region.c - #if 0'd means memleak */
	gwt_region_destroy(temp);
#endif
	return 0;
}

int gwt_visible_raise(gwt_window_t old_z, gwt_window_t new_z, gwt_window_t win)
{
	/*
	 * old_z is the window that was above win,
	 * new_z is the window that is win (or where win would be now - NULL is top).
	 * Should be called only after placing win in it's rightful place.
	 */
	gwt_region_t temp;
	gwt_window_t sibling;
	gwt_region_create(&temp);

	sibling=old_z;
	while ( sibling != new_z ) {
		if (sibling->hidden!=1) {
			gwt_region_copy(temp, sibling->_family_visible);
			gwt_region_intersection(temp, win->geometry);
			gwt_region_difference(sibling->_family_visible, temp);
			gwt_region_union(win->_family_visible, temp);
		}
		sibling=GWT_Z_UP(sibling);
	}
#if 0	/* Segfault! check tt_region.c - #if 0'd means memleak */
	gwt_region_destroy(temp);
#endif
	return 0;
}

int gwt_visible_hide(gwt_window_t win)
{
	gwt_window_t sibling;
	gwt_region_t temp;
	if (win->hidden==1) return 0;
	gwt_region_create(&temp);

	sibling=GWT_Z_DOWN(win);
	while (sibling!=NULL) {
		if (sibling->hidden!=1) {
			gwt_region_copy(temp, sibling->geometry);
			gwt_region_intersection(temp, win->_family_visible);
			gwt_region_union(sibling->_family_visible, temp);
			gwt_region_difference(win->_family_visible, temp);
		}
		sibling=GWT_Z_DOWN(sibling);
	}
	gwt_region_init(win->_family_visible, 0, 0, 0, 0);
#if 0
	gwt_region_destroy(temp);
#endif
	return 0;
}

int gwt_visible_show(gwt_window_t win)
{
	gwt_window_t sibling;
	if (win->hidden==1) return 0;

	gwt_region_copy(win->_family_visible, win->geometry);
	
	/* Remove parts of siblings below hidden by win */
	/*
	 * It seems that this must be done first because
	 * of an error with subtracting a region with
	 * multiple rects (this is an error in tt_region.c)
	 */
	sibling=GWT_Z_DOWN(win);
	while (sibling!=NULL) {
		if (sibling->hidden!=1)
			gwt_region_difference(sibling->_family_visible, win->_family_visible);
		sibling=GWT_Z_DOWN(sibling);
	}
	
	/* Remove parts of win hidden by siblings on top */
	sibling=GWT_Z_UP(win);
	while (sibling!=NULL) {
		if (sibling->hidden!=1)
			gwt_region_difference(win->_family_visible, sibling->_family_visible);
		sibling=GWT_Z_UP(sibling);
	}

	return 0;
}
