/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: region.h,v $
 * Revision 1.4  1998/09/02 02:21:58  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.3  1998/08/23 18:57:19  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.2  1998/08/11 22:09:13  ortalo
 * Incorporated the work made by Tristan Wibberley. Still in alpha
 * development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#ifndef __GGI_GWT_REGION_H
#define __GGI_GWT_REGION_H

#include "tt_region.h"
#include <malloc.h>

typedef region_t gwt_region;
typedef gwt_region *gwt_region_t;

int gwt_region_create(gwt_region_t *region);
int gwt_region_init(gwt_region_t region, int left, int top,
					 int right, int bottom);
int gwt_region_copy(gwt_region_t dest, gwt_region_t src);	/* inits too */
int gwt_region_union(gwt_region_t resr1, gwt_region_t r2);
int gwt_region_intersection(gwt_region_t resr1, gwt_region_t r2);
int gwt_region_difference(gwt_region_t resr1, gwt_region_t r2);
int gwt_region_move(gwt_region_t region, int dx, int dy);
int gwt_region_bounds(gwt_region_t region, ggi_coord *tl, ggi_coord *br);
int gwt_region_contains_point(gwt_region_t region, int x, int y);
int gwt_region_rect(gwt_region_t region, int rectno,
			ggi_coord *tl, ggi_coord *br);
int gwt_region_destroy(gwt_region_t region);

#endif /* __GGI_GWT_REGION_H */

