/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: hide.c,v $
 * Revision 1.5  1998/09/02 02:21:45  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.4  1998/08/23 18:57:10  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.3  1998/08/16 18:40:55  ortalo
 * A new version, STILL IN VERY ALPHA STATE... (Be patient.)
 * (However, this version is a little better... :-)
 *
 * Revision 1.2  1998/08/11 22:10:07  ortalo
 * Incorporated the changes made by Tristan Wibberley. The code is
 * still in alpha development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#include "internal.h"

/**************************************************************************
 *                     GWT PUBLIC EXPORTED FUNCTIONS                      *
 **************************************************************************/

int implicitHideChildren(gwt_window_t win);	/* hide because of parents being hidden */
int implicitShowChildren(gwt_window_t win);

int gwtHide(gwt_window_t win) {
  if (win->level==0) return 1;
  if (win->hidden==1) return 0;

DPRINT("GWT: Uncovering Parent win=%p\n", win);
  gwt_visible_hide(win);
  gwt_visible_setvisinv_family(win);
DPRINT("GWT: Uncovered Parent win=%p\n", win);

  win->hidden = 1;
  implicitHideChildren(win);
  return 0;
}
int gwtShow(gwt_window_t win) {
  if (win->hidden==0) return 0;
  win->hidden = 0;

DPRINT("GWT: Covering Parent win=%p\n", win);
  gwt_visible_show(win);
  gwt_visible_setvisinv_family(win);
DPRINT("GWT: Covered Parent win=%p\n", win);
  implicitShowChildren(win);

  return 0;
}
int gwtIsHidden(gwt_window_t win) {
  return (win->hidden == 1);
}
int gwtIsVisible(gwt_window_t win) {
  return (win->_implicit_hide==0 && win->hidden==0);
}

int implicitHideChildren(gwt_window_t win) {
  gwt_window_t curr;

  curr=GWT_Z_BOTTOM_CHILD(win);
  while (curr != NULL) {
    curr->_implicit_hide=1;
    implicitHideChildren(curr);
    curr=GWT_Z_UP(curr);
  }
  return 0;
}

int implicitShowChildren(gwt_window_t win) {
  gwt_window_t curr;
  if (!gwtIsVisible(win)) return 1;

  curr=GWT_Z_BOTTOM_CHILD(win);
  while (curr != NULL) {
    curr->_implicit_hide=0;
    implicitShowChildren(curr);
    curr=GWT_Z_UP(curr);
  }
  return 0;
}
