/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: geometry.c,v $
 * Revision 1.5  1998/09/02 02:21:44  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.4  1998/08/23 18:57:09  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.3  1998/08/16 18:40:54  ortalo
 * A new version, STILL IN VERY ALPHA STATE... (Be patient.)
 * (However, this version is a little better... :-)
 *
 * Revision 1.2  1998/08/11 22:10:06  ortalo
 * Incorporated the changes made by Tristan Wibberley. The code is
 * still in alpha development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#include "internal.h"

int _gwt_move_children(gwt_window_t win, int dx, int dy) {
	gwt_window_t curr;

	curr=GWT_Z_BOTTOM_CHILD(win);
	while (curr != NULL) {
		gwt_region_move(curr->geometry, dx, dy);
		gwt_region_move(curr->visible, dx, dy);
		gwt_region_move(curr->_family_visible, dx, dy);
		gwt_region_move(curr->_external_visible, dx, dy);
		gwt_region_move(curr->invalid, dx, dy);
		_gwt_move_children(curr, dx, dy);
		curr=GWT_Z_UP(curr);
	}
	return 0;
}

int _gwt_move(gwt_window_t win, sint16 x, sint16 y) {
	int dx, dy;
	gwt_region_t newexternal, oldexternal;
	if (win->level==0) return 1;
        
	dx=x-win->origin.x; dy=y-win->origin.y;

	/* HackAttack!!! uncover, then cover again - does the job, but yeuch! */
	gwt_visible_hide(win);
	
	gwt_region_create(&oldexternal);
	gwt_region_create(&newexternal);
	gwt_region_copy(oldexternal, win->_external_visible);

	gwt_region_move(win->geometry, dx, dy);
	gwt_region_move(win->visible, dx, dy);
	gwt_region_move(win->invalid, dx, dy);
	win->origin.x=x; win->origin.y=y;
	_gwt_move_children(win, dx, dy);

	gwt_visible_show(win);
	gwt_visible_setvisinv_family(win);
	
	gwt_region_copy(newexternal, win->_external_visible);
	gwt_region_move(newexternal, -dx, -dy);
	gwt_region_intersection(oldexternal, newexternal);
	gwt_copy_displayed_region(win->visual, oldexternal, dx, dy);
	gwt_region_destroy(newexternal);
	gwt_region_destroy(oldexternal);
	return 0;
}

int _gwt_resize(gwt_window_t win, uint16 w, uint16 h){
	gwt_region_t bbox;
	ggi_coord tl, br;
	if (win->level==0) return 1;
	/* Another HackAttack!!! */
	gwt_visible_hide(win);
	
	gwt_region_bounds(win->geometry, &tl, &br);
	gwt_region_create(&bbox);
	gwt_region_init(bbox, tl.x, tl.y, tl.x+w, tl.y+h);
	gwt_region_union(win->geometry, bbox);
	gwt_region_intersection(win->geometry, bbox);

	gwt_visible_show(win);
	gwt_visible_setvisinv_family(win);

	return 0;
}

int gwt_move(gwt_window_t win, sint16 x, sint16 y) {
	return _gwt_move(win, x, y);
}

int gwt_resize(gwt_window_t win, uint16 w, uint16 h) {
	return _gwt_resize(win, w, h);
}

int gwt_set_geometry(gwt_window_t win, sint16 x, sint16 y, uint16 w, uint16 h) {
	int status;
	status = _gwt_move(win, x, y);
	if ( status )
		return status;
	status = _gwt_resize(win, w, h);
	return status;
}
#if 0
int gwt_get_region(gwt_region *region, gwt_window_t win, gwt_window_t relative_to)
{
	gwt_region relto;

	gwt_region_copy(region, &win->geometry);
	region->pos.x = region->pos.y = 0;

	if ( win != relative_to ) {
		while ( win->level > 0 ) {
			region->pos.x += win->geometry.pos.x;
			region->pos.y += win->geometry.pos.y;
			win = win->wparent;
		}	

		if ( relative_to != NULL ) {
			gwt_region_copy(&relto, &relative_to->geometry);
			relto.pos.x = relto.pos.y = 0;
			while ( relative_to->level > 0 ) {
				relto.pos.x += relative_to->geometry.pos.x;
				relto.pos.y += relative_to->geometry.pos.y;
				relative_to = relative_to->wparent;
			}
			region->pos.x -= relto.pos.x;
			region->pos.y -= relto.pos.y;
		}
	}

	return gwt_region_is_empty(region);
}
#endif
/**************************************************************************
 *                    GWT PUBLIC EXPORTED FUNCTIONS                       *
 **************************************************************************/
int gwtResize(gwt_window_t win, int w, int h) {
	return gwt_resize(win, w, h);
}

int gwtMove(gwt_window_t win, int x, int y) {
	return gwt_move(win, x, y);
}

int gwtSetGeometry(gwt_window_t win, int x, int y, int w, int h) {
	return gwt_set_geometry(win, x, y, w, h);
}

int gwtGetRegion(gwt_window_t win, gwt_region_t region) {
	gwt_region_copy(region, win->geometry);
	if (win->level != 0) {
		gwt_region_move(region, -win->origin.x, -win->origin.y);
	}
	return 0;
}

int gwtGetInvalidRegion(gwt_window_t win, gwt_region_t region) {
	gwt_region_copy(region, win->invalid);
	if (win->level != 0) {
		gwt_region_move(region, -win->origin.x, -win->origin.y);
	}
	return 0;
}

int gwtGetVisibleRegion(gwt_window_t win, gwt_region_t region) {
	gwt_region_copy(region, win->visible);
	if (win->level != 0) {
		gwt_region_move(region, -win->origin.x, -win->origin.y);
	}
	return 0;
}

int gwtIterateRect(gwt_region_t region, int *rectno, ggi_coord *tl, ggi_coord *size) {
	return gwt_region_rect(region, (*rectno)++, tl, size);
}

int gwtRectMapOrigin(ggi_coord *origin, gwt_window_t win) {
	if (win->level != 0) {
		origin->x+=win->origin.x-win->wparent->origin.x;
		origin->y+=win->origin.y-win->wparent->origin.y;
		return 0;
	}
	return -1;
}

int gwtValidate(gwt_window_t win)
{
	return gwt_validate_all(win);
}
